/// <reference path="./internal_*.d.ts" />
declare namespace org.slf4j {
    interface Marker extends Internal.Serializable {
        /**
         * @deprecated
        */
        abstract hasChildren(): boolean;
        abstract hashCode(): number;
        abstract remove(arg0: org.slf4j.Marker_): boolean;
        abstract getName(): string;
        abstract add(arg0: org.slf4j.Marker_): void;
        abstract iterator(): Internal.Iterator<org.slf4j.Marker>;
        abstract equals(arg0: any): boolean;
        abstract hasReferences(): boolean;
        abstract contains(arg0: org.slf4j.Marker_): boolean;
        abstract contains(arg0: string): boolean;
        get name(): string
        readonly ANY_NON_NULL_MARKER: "+";
        readonly ANY_MARKER: "*";
    }
    type Marker_ = Marker;
}
declare namespace io.github.fabricators_of_create.porting_lib.transfer.item {
    class ItemStackHandler implements Internal.SlottedStackStorage, Internal.INBTSerializable<Internal.CompoundTag> {
        constructor(stacks: Internal.ItemStack_[])
        constructor()
        constructor(stacks: number)
        empty(): boolean;
        extract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        supportsExtraction(): boolean;
        extract(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getSlotCount(): number;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        serializeNBT(): Internal.Tag;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        getStackInSlot(slot: number): Internal.ItemStack;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        getVariantInSlot(slot: number): Internal.ItemVariant;
        getSlot(slot: number): Internal.ItemStackHandlerSlot;
        deserializeNBT(arg0: Internal.Tag_): void;
        getSlotLimit(slot: number): number;
        insert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        getSlotsContaining(item: Internal.Item_): Internal.SortedSet<Internal.ItemStackHandlerSlot>;
        insert(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        setSize(size: number): void;
        getVersion(): number;
        exactView(arg0: any): Internal.StorageView<any>;
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        set size(size: number)
        get version(): number
    }
    type ItemStackHandler_ = ItemStackHandler;
}
declare namespace earth.terrarium.botarium.util {
    interface Serializable {
        abstract serialize(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        abstract deserialize(arg0: Internal.CompoundTag_): void;
    }
    type Serializable_ = Serializable;
}
declare namespace Internal {
    interface LivingEntityEvents$Drops {
        abstract onLivingEntityDrops(arg0: Internal.LivingEntity_, arg1: DamageSource_, arg2: Internal.Collection_<Internal.ItemEntity>, arg3: number, arg4: boolean): boolean;
        (arg0: Internal.LivingEntity, arg1: DamageSource, arg2: Internal.Collection<Internal.ItemEntity>, arg3: number, arg4: boolean): boolean;
    }
    type LivingEntityEvents$Drops_ = LivingEntityEvents$Drops;
    class ReplaceSphereConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.IntProvider_)
        radius(): Internal.IntProvider;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.ReplaceSphereConfiguration>;
        readonly targetState: Internal.BlockState;
        readonly replaceState: Internal.BlockState;
    }
    type ReplaceSphereConfiguration_ = ReplaceSphereConfiguration;
    class MechanicalPistonBlockEntity extends Internal.LinearActuatorBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        addExceptionToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>): boolean;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        assemble(): void;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type MechanicalPistonBlockEntity_ = MechanicalPistonBlockEntity;
    interface CustomHitEffectsBlock {
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
    }
    type CustomHitEffectsBlock_ = CustomHitEffectsBlock;
    class PocketBrain implements Internal.IPocketAccess {
        constructor(holder: Internal.PocketHolder_, upgrade: dan200.computercraft.api.upgrades.UpgradeData_<Internal.IPocketUpgrade>, colour: number, properties: Internal.ServerComputer$Properties_)
        setUpgrade(upgrade: dan200.computercraft.api.upgrades.UpgradeData_<Internal.IPocketUpgrade>): void;
        getLevel(): Internal.ServerLevel;
        getPosition(): Vec3d;
        updateHolder(newHolder: Internal.PocketHolder_): void;
        getUpgrade(): dan200.computercraft.api.upgrades.UpgradeData<Internal.IPocketUpgrade>;
        setLight(colour: number): void;
        getUpgradeNBTData(): Internal.CompoundTag;
        getColour(): number;
        computer(): Internal.PocketServerComputer;
        getEntity(): Internal.Entity;
        getLight(): number;
        setColour(colour: number): void;
        updateItem(stack: Internal.ItemStack_): boolean;
        updateUpgradeNBTData(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getUpgrades(): Internal.Map<ResourceLocation, Internal.IPeripheral>;
        invalidatePeripheral(): void;
        set upgrade(upgrade: dan200.computercraft.api.upgrades.UpgradeData_<Internal.IPocketUpgrade>)
        get level(): Internal.ServerLevel
        get position(): Vec3d
        get upgrade(): dan200.computercraft.api.upgrades.UpgradeData<Internal.IPocketUpgrade>
        set light(colour: number)
        get upgradeNBTData(): Internal.CompoundTag
        get colour(): number
        get entity(): Internal.Entity
        get light(): number
        set colour(colour: number)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get upgrades(): Internal.Map<ResourceLocation, Internal.IPeripheral>
    }
    type PocketBrain_ = PocketBrain;
    class VariantBlockStateGenerator {
        constructor()
        variant(key: string, consumer: Internal.Consumer_<Internal.VariantBlockStateGenerator$Variant>): void;
        simpleVariant(key: string, model: string): void;
        toJson(): Internal.JsonObject;
    }
    type VariantBlockStateGenerator_ = VariantBlockStateGenerator;
    class RollingMillBlockEntity$RollingMillInventoryHandler extends Internal.CombinedStorage<Internal.ItemVariant, io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler> {
        constructor(arg0: Internal.RollingMillBlockEntity_)
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        extract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        insert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static asClass<T>(): Internal.Storage<T>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        get version(): number
    }
    type RollingMillBlockEntity$RollingMillInventoryHandler_ = RollingMillBlockEntity$RollingMillInventoryHandler;
    interface IOrientableBlock {
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        abstract getOrientationStrategy(): Internal.IOrientationStrategy;
        get orientationStrategy(): Internal.IOrientationStrategy
        (): Internal.IOrientationStrategy_;
    }
    type IOrientableBlock_ = IOrientableBlock;
    class StandingSignBlockBOP extends Internal.StandingSignBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.WoodType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type StandingSignBlockBOP_ = StandingSignBlockBOP;
    class Tristate extends Internal.Enum<Internal.Tristate> {
        static read(buffer: Internal.FriendlyByteBuf_): Internal.Tristate;
        static valueOf(name: string): Internal.Tristate;
        write(buffer: Internal.FriendlyByteBuf_): void;
        static read(nbt: Internal.CompoundTag_, key: string): Internal.Tristate;
        isTrue(): boolean;
        static values(): Internal.Tristate[];
        isFalse(): boolean;
        getOpposite(): this;
        isDefault(): boolean;
        get(def: boolean): boolean;
        write(nbt: Internal.CompoundTag_, key: string): void;
        get "true"(): boolean
        get "false"(): boolean
        get opposite(): Internal.Tristate
        get "default"(): boolean
        static readonly VALUES: Internal.Tristate[];
        readonly name: string;
        static readonly FALSE: Internal.Tristate;
        static readonly DEFAULT: Internal.Tristate;
        readonly result: Internal.InteractionResult;
        readonly color: Internal.Color4I;
        readonly displayName: string;
        static readonly TRUE: Internal.Tristate;
        static readonly NAME_MAP: Internal.NameMap<Internal.Tristate>;
        readonly icon: Internal.Icon;
    }
    type Tristate_ = Tristate | "false" | "default" | "true";
    class RenderChunkRegion implements Internal.BlockAndTintGetter, Internal.RenderAttachedBlockView, Internal.RenderDataMapConsumer {
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        getShade($$0: Internal.Direction_, $$1: boolean): number;
        getBlockState($$0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        getHeight(): number;
        getBlockEntity($$0: BlockPos_): Internal.BlockEntity;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        canSeeSky($$0: BlockPos_): boolean;
        isOutsideBuildHeight($$0: number): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        getFluidState($$0: BlockPos_): Internal.FluidState;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        fabric_acceptRenderDataMap(renderDataMap: Internal.Long2ObjectMap_<any>): void;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getSectionIndexFromSectionY($$0: number): number;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get minBuildHeight(): number
        get sectionsCount(): number
        get maxLightLevel(): number
    }
    type RenderChunkRegion_ = RenderChunkRegion;
    interface LootPoolEntryAccessor {
        abstract getConditions(): Internal.LootItemCondition[];
        get conditions(): Internal.LootItemCondition[]
        (): Internal.LootItemCondition_[];
    }
    type LootPoolEntryAccessor_ = LootPoolEntryAccessor;
    class MovementContext {
        constructor(world: Internal.Level_, info: Internal.StructureTemplate$StructureBlockInfo_, contraption: Internal.Contraption_)
        getAnimationSpeed(): number;
        static readNBT(world: Internal.Level_, info: Internal.StructureTemplate$StructureBlockInfo_, nbt: Internal.CompoundTag_, contraption: Internal.Contraption_): Internal.MovementContext;
        getItemStorage(): Internal.MountedItemStorage;
        getFilterFromBE(): Internal.FilterItemStack;
        getFluidStorage(): Internal.MountedFluidStorage;
        writeToNBT(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        get animationSpeed(): number
        get itemStorage(): Internal.MountedItemStorage
        get filterFromBE(): Internal.FilterItemStack
        get fluidStorage(): Internal.MountedFluidStorage
        stall: boolean;
        localPos: BlockPos;
        temporaryData: any;
        world: Internal.Level;
        state: Internal.BlockState;
        motion: Vec3d;
        data: Internal.CompoundTag;
        relativeMotion: Vec3d;
        disabled: boolean;
        blockEntityData: Internal.CompoundTag;
        contraption: Internal.Contraption;
        position: Vec3d;
        rotation: Internal.UnaryOperator<Vec3d>;
        firstMovement: boolean;
    }
    type MovementContext_ = MovementContext;
    class Medium404TrailingBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type Medium404TrailingBogeyBlock_ = Medium404TrailingBogeyBlock;
    class BlockElementFace implements Internal.BlockElementFaceExtensions {
        constructor($$0: Internal.Direction_, $$1: number, $$2: string, $$3: Internal.BlockFaceUV_)
        port_lib$getRenderMaterial(): Internal.MaterialData;
        port_lib$setRenderMaterial(material: Internal.MaterialData_): void;
        readonly texture: string;
        readonly tintIndex: number;
        readonly uv: Internal.BlockFaceUV;
        readonly cullForDirection: Internal.Direction;
        static readonly NO_TINT: -1;
    }
    type BlockElementFace_ = BlockElementFace;
    interface AccessItemRenderer {
        abstract indium$renderBakedItemModel(arg0: Internal.BakedModel_, arg1: Internal.ItemStack_, arg2: number, arg3: number, arg4: Internal.PoseStack_, arg5: Internal.VertexConsumer_): void;
        (arg0: Internal.BakedModel, arg1: Internal.ItemStack, arg2: number, arg3: number, arg4: Internal.PoseStack, arg5: Internal.VertexConsumer): void;
    }
    type AccessItemRenderer_ = AccessItemRenderer;
    class SoulSandBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SoulSandBlock_ = SoulSandBlock;
    class DisplayLinkBlockItem extends Internal.ClickToLinkBlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DisplayLinkBlockItem_ = DisplayLinkBlockItem;
    class Locale$Category extends Internal.Enum<Internal.Locale$Category> {
        static valueOf(arg0: string): Internal.Locale$Category;
        static values(): Internal.Locale$Category[];
        static readonly FORMAT: Internal.Locale$Category;
        static readonly DISPLAY: Internal.Locale$Category;
    }
    type Locale$Category_ = Locale$Category | "display" | "format";
    class PlayerModelPart extends Internal.Enum<Internal.PlayerModelPart> {
        static valueOf($$0: string): Internal.PlayerModelPart;
        getName(): net.minecraft.network.chat.Component;
        getBit(): number;
        static values(): Internal.PlayerModelPart[];
        getMask(): number;
        getId(): string;
        get name(): net.minecraft.network.chat.Component
        get bit(): number
        get mask(): number
        get id(): string
        static readonly CAPE: Internal.PlayerModelPart;
        static readonly LEFT_SLEEVE: Internal.PlayerModelPart;
        static readonly RIGHT_PANTS_LEG: Internal.PlayerModelPart;
        static readonly LEFT_PANTS_LEG: Internal.PlayerModelPart;
        static readonly RIGHT_SLEEVE: Internal.PlayerModelPart;
        static readonly JACKET: Internal.PlayerModelPart;
        static readonly HAT: Internal.PlayerModelPart;
    }
    type PlayerModelPart_ = "jacket" | "hat" | "right_sleeve" | "cape" | "right_pants_leg" | "left_sleeve" | "left_pants_leg" | PlayerModelPart;
    class HeadData extends Internal.Record {
        constructor(playerInfo: Internal.PlayerInfo_, codePointIndex: number)
        codePointIndex(): number;
        playerInfo(): Internal.PlayerInfo;
        hasHeadPosition(): boolean;
        static of(playerInfo: Internal.PlayerInfo_): Internal.HeadData;
        static EMPTY: Internal.HeadData;
    }
    type HeadData_ = HeadData;
    class WitherSkullBlock extends Internal.SkullBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        static checkSpawn($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.SkullBlockEntity_): void;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static canSpawnMob($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.ItemStack_): boolean;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type WitherSkullBlock_ = WitherSkullBlock;
    class Package extends Internal.NamedPackage implements Internal.AnnotatedElement {
        getSpecificationVendor(): string;
        getSpecificationVersion(): string;
        /**
         * @deprecated
        */
        static getPackage(arg0: string): Internal.Package;
        static getPackages(): Internal.Package[];
        isCompatibleWith(arg0: string): boolean;
        getAnnotation<A extends Internal.Annotation>(arg0: A): A;
        getImplementationVersion(): string;
        getImplementationVendor(): string;
        getName(): string;
        isSealed(arg0: Internal.URL_): boolean;
        getAnnotations(): Internal.Annotation[];
        getDeclaredAnnotation<A extends Internal.Annotation>(arg0: A): A;
        getAnnotationsByType<A extends Internal.Annotation>(arg0: A): A[];
        getSpecificationTitle(): string;
        isSealed(): boolean;
        getDeclaredAnnotations(): Internal.Annotation[];
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        getDeclaredAnnotationsByType<A extends Internal.Annotation>(arg0: A): A[];
        getImplementationTitle(): string;
        get specificationVendor(): string
        get specificationVersion(): string
        get packages(): Internal.Package[]
        get implementationVersion(): string
        get implementationVendor(): string
        get name(): string
        get annotations(): Internal.Annotation[]
        get specificationTitle(): string
        get sealed(): boolean
        get declaredAnnotations(): Internal.Annotation[]
        get implementationTitle(): string
    }
    type Package_ = Package;
    class WorldDimensions$Complete extends Internal.Record {
        constructor($$0: Internal.Registry_<Internal.LevelStem>, $$1: Internal.PrimaryLevelData$SpecialWorldProperty_)
        lifecycle(): Internal.Lifecycle;
        dimensionsRegistryAccess(): Internal.RegistryAccess$Frozen;
        specialWorldProperty(): Internal.PrimaryLevelData$SpecialWorldProperty;
        dimensions(): Internal.Registry<Internal.LevelStem>;
    }
    type WorldDimensions$Complete_ = WorldDimensions$Complete;
    class ToolPartItem extends Internal.MaterialItem implements Internal.IToolPart {
        constructor(properties: Internal.Item$Properties_, id: Internal.MaterialStatsId_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        withMaterial(material: Internal.MaterialVariantId_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canUseMaterial(material: Internal.MaterialId_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        withMaterialForDisplay(materialId: Internal.MaterialVariantId_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static withMaterial(stack: Internal.ItemStack_, material: Internal.MaterialVariantId_): Internal.ItemStack;
        static getMaterialFromStack(stack: Internal.ItemStack_): Internal.MaterialVariantId;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        canUseMaterial(mat: Internal.IMaterial_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getStatType(): Internal.MaterialStatsId;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get statType(): Internal.MaterialStatsId
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly MATERIAL_KEY: "tooltip.tconstruct.part.material_id";
        readonly materialStatId: Internal.MaterialStatsId;
    }
    type ToolPartItem_ = ToolPartItem;
    class EntityHitResult extends Internal.HitResult {
        constructor($$0: Internal.Entity_, $$1: Vec3d_)
        constructor($$0: Internal.Entity_)
        getEntity(): Internal.Entity;
        get entity(): Internal.Entity
    }
    type EntityHitResult_ = EntityHitResult;
    class ClientboundHurtAnimationPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: number)
        constructor($$0: Internal.LivingEntity_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        id(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        yaw(): number;
        get skippable(): boolean
    }
    type ClientboundHurtAnimationPacket_ = ClientboundHurtAnimationPacket;
    class ClientboundAnimatePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_, $$1: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getAction(): number;
        isSkippable(): boolean;
        getId(): number;
        get action(): number
        get skippable(): boolean
        get id(): number
        static readonly WAKE_UP: 2;
        static readonly SWING_OFF_HAND: 3;
        static readonly MAGIC_CRITICAL_HIT: 5;
        static readonly SWING_MAIN_HAND: 0;
        static readonly CRITICAL_HIT: 4;
    }
    type ClientboundAnimatePacket_ = ClientboundAnimatePacket;
    abstract class PlayerEventJS extends Internal.LivingEntityEventJS {
        constructor()
        /**
         * Removes the specified game stage from the player
        */
        removeGameStage(stage: string): void;
        /**
         * Adds the specified game stage to the player
        */
        addGameStage(stage: string): void;
        /**
         * Checks if the player has the specified game stage
        */
        hasGameStage(stage: string): boolean;
    }
    type PlayerEventJS_ = PlayerEventJS;
    interface LocalIntRef {
        abstract set(arg0: number): void;
        abstract get(): number;
    }
    type LocalIntRef_ = LocalIntRef;
    interface RakeItem$RakeLogic {
        abstract apply(arg0: Internal.AgriCrop_, arg1: Internal.ItemStack_, arg2: Internal.Player_): void;
        (arg0: Internal.AgriCrop, arg1: Internal.ItemStack, arg2: Internal.Player): void;
    }
    type RakeItem$RakeLogic_ = RakeItem$RakeLogic;
    interface LongBidirectionalIterable extends Internal.LongIterable {
        forEach(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        abstract iterator(): Internal.LongBidirectionalIterator;
        spliterator(): Internal.Spliterator<any>;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        longIterator(): Internal.LongIterator;
        longSpliterator(): Internal.LongSpliterator;
        forEach(arg0: Internal.LongConsumer_): void;
        (): Internal.LongBidirectionalIterator_;
    }
    type LongBidirectionalIterable_ = LongBidirectionalIterable;
    class TrollType {
        constructor(name: string, material: Internal.CustomArmorMaterial_, biomePredicate: Internal.Predicate_<Internal.Holder<Internal.Biome>>, lootTable: ResourceLocation_, ...weapons: Internal.TrollType$BuiltinWeapon_[])
        getEyesTexture(): ResourceLocation;
        getMaterial(): Internal.CustomArmorMaterial;
        static getBiomeType(biome: Internal.Holder_<Internal.Biome>): Internal.TrollType;
        allowSpawn(biome: Internal.Holder_<Internal.Biome>): boolean;
        getName(): string;
        getTexture(): ResourceLocation;
        static values(): Internal.List<Internal.TrollType>;
        static initArmors(): void;
        static getWeaponForType(troll: Internal.TrollType_): Internal.TrollType$BuiltinWeapon;
        getLootTable(): ResourceLocation;
        static getByName(name: string): Internal.TrollType;
        getStatueTexture(): ResourceLocation;
        get eyesTexture(): ResourceLocation
        get material(): Internal.CustomArmorMaterial
        get name(): string
        get texture(): ResourceLocation
        get lootTable(): ResourceLocation
        get statueTexture(): ResourceLocation
        leather: Internal.RegistrySupplier<Internal.Item>;
        chestplate: Internal.RegistrySupplier<Internal.Item>;
        helmet: Internal.RegistrySupplier<Internal.Item>;
        static readonly FOREST: Internal.TrollType;
        static readonly FROST: Internal.TrollType;
        leggings: Internal.RegistrySupplier<Internal.Item>;
        boots: Internal.RegistrySupplier<Internal.Item>;
        static readonly MOUNTAIN: Internal.TrollType;
    }
    type TrollType_ = TrollType;
    interface Consumer <T> {
        andThen(arg0: Internal.Consumer_<T>): this;
        abstract accept(arg0: T): void;
        (arg0: T): void;
    }
    type Consumer_<T> = Consumer<T>;
    class BlockStateModifyCallbackJS {
        constructor(state: Internal.BlockState_)
        /**
         * Checks if this block has the specified property
        */
        hasProperty<T extends Internal.Comparable<T>>(property: Internal.Property_<T>): boolean;
        /**
         * Mirror the block using the specified Mirror
        */
        mirror(mirror: Internal.Mirror_): this;
        /**
         * Get a map of this blocks properties to it's value
        */
        getValues(): Internal.ImmutableMap<Internal.Property<any>, Internal.Comparable<any>>;
        /**
         * Gets the value of the pased in property
        */
        get<T extends Internal.Comparable<T>>(property: Internal.Property_<T>): T;
        /**
         * Gets the value of the passed in property
        */
        getValue<T extends Internal.Comparable<T>>(property: Internal.Property_<T>): T;
        /**
         * Sets the value of the specified property
        */
        setValue<T extends Internal.Comparable<T>, V extends T>(property: Internal.Property_<T>, comparable: V): this;
        /**
         * Sets the value of the specified boolean property
        */
        set(property: Internal.BooleanProperty_, value: boolean): this;
        populateNeighbours(map: Internal.Map_<Internal.Map<Internal.Property<any>, Internal.Comparable<any>>, Internal.BlockState>): this;
        /**
         * Sets the value of the specified enum property
        */
        set<T extends Internal.Enum<T> & Internal.StringRepresentable>(property: Internal.EnumProperty_<T>, value: string): this;
        /**
         * Cycles the property
        */
        cycle<T extends Internal.Comparable<T>>(property: Internal.Property_<T>): this;
        /**
         * Get the properties this block has that can be changed
        */
        getProperties(): Internal.Collection<Internal.Property<any>>;
        /**
         * Rotate the block using the specified Rotation
        */
        rotate(rotation: Internal.Rotation_): this;
        /**
         * Sets the value of the specified integer property
        */
        set(property: Internal.IntegerProperty_, value: number): this;
        /**
         * Updates the shape of this block. Mostly used in waterloggable blocks to update the water flow
        */
        updateShape(direction: Internal.Direction_, blockState: Internal.BlockState_, levelAccessor: Internal.LevelAccessor_, blockPos: BlockPos_, blockPos2: BlockPos_): this;
        /**
         * Gets the state. If it has been modified, gets the new state
        */
        getState(): Internal.BlockState;
        /**
         * Gets the value of the passed in property as an Optional. If the property does not exist in this block the Optional will be empty
        */
        getOptionalValue<T extends Internal.Comparable<T>>(property: Internal.Property_<T>): Internal.Optional<T>;
        /**
         * Get a map of this blocks properties to it's value
        */
        get values(): Internal.ImmutableMap<Internal.Property<any>, Internal.Comparable<any>>
        /**
         * Get the properties this block has that can be changed
        */
        get properties(): Internal.Collection<Internal.Property<any>>
        /**
         * Gets the state. If it has been modified, gets the new state
        */
        get state(): Internal.BlockState
    }
    type BlockStateModifyCallbackJS_ = BlockStateModifyCallbackJS;
    class DateTimeFormatter {
        static ofPattern(arg0: string, arg1: Internal.Locale_): Internal.DateTimeFormatter;
        withChronology(arg0: Internal.Chronology_): this;
        parse(arg0: Internal.CharSequence_): Internal.TemporalAccessor;
        static parsedExcessDays(): Internal.TemporalQuery<Internal.Period>;
        parse<T>(arg0: Internal.CharSequence_, arg1: Internal.TemporalQuery_<T>): T;
        parse(arg0: Internal.CharSequence_, arg1: Internal.ParsePosition_): Internal.TemporalAccessor;
        localizedBy(arg0: Internal.Locale_): this;
        getZone(): Internal.ZoneId;
        withResolverStyle(arg0: Internal.ResolverStyle_): this;
        parseBest(arg0: Internal.CharSequence_, ...arg1: Internal.TemporalQuery_<any>[]): Internal.TemporalAccessor;
        toFormat(arg0: Internal.TemporalQuery_<any>): Internal.Format;
        static ofLocalizedDate(arg0: Internal.FormatStyle_): Internal.DateTimeFormatter;
        static parsedLeapSecond(): Internal.TemporalQuery<boolean>;
        formatTo(arg0: Internal.TemporalAccessor_, arg1: Internal.Appendable_): void;
        static ofLocalizedDateTime(arg0: Internal.FormatStyle_, arg1: Internal.FormatStyle_): Internal.DateTimeFormatter;
        withResolverFields(...arg0: Internal.TemporalField_[]): this;
        static ofLocalizedPattern(arg0: string): Internal.DateTimeFormatter;
        withDecimalStyle(arg0: Internal.DecimalStyle_): this;
        getChronology(): Internal.Chronology;
        toFormat(): Internal.Format;
        withResolverFields(arg0: Internal.Set_<Internal.TemporalField>): this;
        withLocale(arg0: Internal.Locale_): this;
        getResolverStyle(): Internal.ResolverStyle;
        static ofPattern(arg0: string): Internal.DateTimeFormatter;
        static ofLocalizedDateTime(arg0: Internal.FormatStyle_): Internal.DateTimeFormatter;
        parseUnresolved(arg0: Internal.CharSequence_, arg1: Internal.ParsePosition_): Internal.TemporalAccessor;
        getResolverFields(): Internal.Set<Internal.TemporalField>;
        format(arg0: Internal.TemporalAccessor_): string;
        withZone(arg0: Internal.ZoneId_): this;
        getLocale(): Internal.Locale;
        getDecimalStyle(): Internal.DecimalStyle;
        static ofLocalizedTime(arg0: Internal.FormatStyle_): Internal.DateTimeFormatter;
        get zone(): Internal.ZoneId
        get chronology(): Internal.Chronology
        get resolverStyle(): Internal.ResolverStyle
        get resolverFields(): Internal.Set<Internal.TemporalField>
        get locale(): Internal.Locale
        get decimalStyle(): Internal.DecimalStyle
        static readonly ISO_DATE: Internal.DateTimeFormatter;
        static readonly ISO_WEEK_DATE: Internal.DateTimeFormatter;
        static readonly ISO_OFFSET_DATE_TIME: Internal.DateTimeFormatter;
        static readonly ISO_TIME: Internal.DateTimeFormatter;
        static readonly ISO_ORDINAL_DATE: Internal.DateTimeFormatter;
        static readonly ISO_OFFSET_TIME: Internal.DateTimeFormatter;
        static readonly ISO_LOCAL_DATE_TIME: Internal.DateTimeFormatter;
        static readonly ISO_OFFSET_DATE: Internal.DateTimeFormatter;
        static readonly BASIC_ISO_DATE: Internal.DateTimeFormatter;
        static readonly ISO_INSTANT: Internal.DateTimeFormatter;
        static readonly ISO_LOCAL_DATE: Internal.DateTimeFormatter;
        static readonly RFC_1123_DATE_TIME: Internal.DateTimeFormatter;
        static readonly ISO_LOCAL_TIME: Internal.DateTimeFormatter;
        static readonly ISO_DATE_TIME: Internal.DateTimeFormatter;
        static readonly ISO_ZONED_DATE_TIME: Internal.DateTimeFormatter;
    }
    type DateTimeFormatter_ = DateTimeFormatter;
    abstract class ConcurrentHashMap$CollectionView <K, V, E> implements Internal.Collection<E>, Internal.Serializable {
        abstract add(arg0: E): boolean;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        toArray(): any[];
        getMap(): Internal.ConcurrentHashMap<K, V>;
        abstract iterator(): Internal.Iterator<E>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        size(): number;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        abstract contains(arg0: any): boolean;
        abstract addAll(arg0: Internal.Collection_<E>): boolean;
        get empty(): boolean
        get map(): Internal.ConcurrentHashMap<K, V>
    }
    type ConcurrentHashMap$CollectionView_<K, V, E> = ConcurrentHashMap$CollectionView<K, V, E>;
    class EnchantmentConvertingRecipe extends Internal.AbstractWorktableRecipe {
        constructor(id: ResourceLocation_, name: string, inputs: Internal.List_<Internal.SizedIngredient>, matchBook: boolean, returnInput: boolean, modifierPredicate: any_<Internal.ModifierId>)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        toolResultSize(): number;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        /**
         * @deprecated
        */
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getRemainingItems($$0: Internal.ITinkerableContainer_): Internal.NonNullList<Internal.ItemStack>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ITinkerableContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type EnchantmentConvertingRecipe_ = EnchantmentConvertingRecipe;
    class SignalBoundary extends Internal.TrackEdgePoint {
        constructor()
        getGroup(side: Internal.TrackNode_): Internal.UUID;
        setGroup(primary: boolean, groupId: Internal.UUID_): void;
        getOverlayFor(blockEntity: BlockPos_): Internal.SignalBlockEntity$OverlayState;
        queueUpdate(side: Internal.TrackNode_): void;
        cycleSignalType(pos: BlockPos_): void;
        isForcedRed(side: Internal.TrackNode_): boolean;
        getTypeFor(blockEntity: BlockPos_): Internal.SignalBlock$SignalType;
        isForcedRed(primary: boolean): boolean;
        getStateFor(blockEntity: BlockPos_): Internal.SignalBlockEntity$SignalState;
        setGroupAndUpdate(side: Internal.TrackNode_, groupId: Internal.UUID_): void;
        updateBlockEntityPower(blockEntity: Internal.SignalBlockEntity_): void;
        cachedStates: Internal.Couple<Internal.SignalBlockEntity$SignalState>;
        groups: Internal.Couple<Internal.UUID>;
        blockEntities: Internal.Couple<Internal.Map<BlockPos, boolean>>;
        sidesToUpdate: Internal.Couple<boolean>;
        types: Internal.Couple<Internal.SignalBlock$SignalType>;
    }
    type SignalBoundary_ = SignalBoundary;
    class DirectionProperty extends Internal.EnumProperty<Internal.Direction> {
        static create($$0: string, $$1: Internal.Collection_<Internal.Direction>): Internal.DirectionProperty;
        static create($$0: string, $$1: Internal.Predicate_<Internal.Direction>): Internal.DirectionProperty;
        static create($$0: string): Internal.DirectionProperty;
        static create($$0: string, ...$$1: Internal.Direction_[]): Internal.DirectionProperty;
    }
    type DirectionProperty_ = DirectionProperty;
    interface ReplacementMatch {
        of(o: any): this;
        readonly NONE: Internal.ReplacementMatch;
    }
    type ReplacementMatch_ = ReplacementMatch | any_;
    class BlockStateBlockItem <T extends Internal.Comparable<T>> extends Internal.BlockItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static create<T extends Internal.Comparable<T>>(blockSupplier: Internal.NonNullSupplier_<Internal.Block>, property: Internal.Property_<T>, value: T, primary: boolean): com.tterrag.registrate.util.nullness.NonNullFunction<Internal.Item$Properties, Internal.BlockStateBlockItem<T>>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static create<T extends Internal.Comparable<T>>(property: Internal.Property_<T>, value: T, primary: boolean): Internal.NonNullBiFunction<Internal.Block, Internal.Item$Properties, Internal.BlockStateBlockItem<T>>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlockStateBlockItem_<T extends Internal.Comparable<T>> = BlockStateBlockItem<T>;
    interface BonemealableBlock {
        abstract isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        abstract performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        abstract isValidBonemealTarget(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): boolean;
    }
    type BonemealableBlock_ = BonemealableBlock;
    class CRBogeyBlock extends Internal.AbstractBogeyBlock<Internal.CRBogeyBlockEntity> implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.CRBogeyBlockEntity>, Internal.SpecialBlockItemRequirement {
        getConnectorAnchorOffset(): Vec3d;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.CRBogeyBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.CRBogeyBlockEntity>;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get connectorAnchorOffset(): Vec3d
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.CRBogeyBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.CRBogeyBlockEntity>
        set destroySpeed(v: number)
    }
    type CRBogeyBlock_ = CRBogeyBlock;
    interface ChunkTrackerHolder {
        get(world: Internal.ClientLevel_): Internal.ChunkTracker;
        abstract sodium$getTracker(): Internal.ChunkTracker;
        (): Internal.ChunkTracker_;
    }
    type ChunkTrackerHolder_ = ChunkTrackerHolder;
    interface IToolStatProvider {
        validate(data: Internal.ToolDefinitionData_): void;
        getDefaultData(): Internal.ToolDefinitionData;
        abstract buildStats(arg0: Internal.ToolDefinition_, arg1: Internal.MaterialNBT_): Internal.StatsNBT;
        abstract isMultipart(): boolean;
        validate(name: string, requiredStat: Internal.MaterialStatsId_, otherStats: Internal.Set_<Internal.MaterialStatsId>, data: Internal.ToolDefinitionData_): void;
        get defaultData(): Internal.ToolDefinitionData
        get multipart(): boolean
    }
    type IToolStatProvider_ = IToolStatProvider;
    class KeyPair implements Internal.Serializable {
        constructor(arg0: Internal.PublicKey_, arg1: Internal.PrivateKey_)
        getPublic(): Internal.PublicKey;
        getPrivate(): Internal.PrivateKey;
        get "public"(): Internal.PublicKey
        get "private"(): Internal.PrivateKey
    }
    type KeyPair_ = KeyPair;
    interface LootManagerConditionManager {
        abstract getKeysToValues(): Internal.Map<Internal.LootDataId<any>, any>;
        get keysToValues(): Internal.Map<Internal.LootDataId<any>, any>
        (): Internal.Map_<Internal.LootDataId<any>, any>;
    }
    type LootManagerConditionManager_ = LootManagerConditionManager;
    class CopperPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.EnumProperty<Internal.FacingOrNone>;
        static readonly ENABLED: Internal.BooleanProperty;
    }
    type CopperPipeBlock_ = CopperPipeBlock;
    interface PressingBehaviour$PressingBehaviourSpecifics {
        abstract tryProcessOnBelt(arg0: Internal.TransportedItemStack_, arg1: Internal.List_<Internal.ItemStack>, arg2: boolean): boolean;
        abstract tryProcessInBasin(arg0: boolean): boolean;
        abstract getKineticSpeed(): number;
        abstract onPressingCompleted(): void;
        abstract getParticleAmount(): number;
        abstract tryProcessInWorld(arg0: Internal.ItemEntity_, arg1: boolean): boolean;
        abstract canProcessInBulk(): boolean;
        get kineticSpeed(): number
        get particleAmount(): number
    }
    type PressingBehaviour$PressingBehaviourSpecifics_ = PressingBehaviour$PressingBehaviourSpecifics;
    abstract class Icon implements Internal.Drawable {
        constructor()
        withUV(x: number, y: number, w: number, h: number, tw: number, th: number): this;
        draw3D(graphics: Internal.GuiGraphics_): void;
        withPadding(padding: number): this;
        withBorder(color: Internal.Color4I_, roundEdges: boolean): this;
        isEmpty(): boolean;
        static empty(): Internal.Color4I;
        aspectRatio(): number;
        withColor(color: Internal.Color4I_): this;
        withTint(color: Internal.Color4I_): this;
        static getIcon(id: ResourceLocation_): Internal.Icon;
        static getIcon(json: Internal.JsonElement_): Internal.Icon;
        combineWith(...icons: Internal.Icon_[]): this;
        hasPixelBuffer(): boolean;
        getIngredient(): any;
        static getIcon(id: string): Internal.Icon;
        combineWith(icon: Internal.Icon_): this;
        withUV(u0: number, v0: number, u1: number, v1: number): this;
        drawStatic(graphics: Internal.GuiGraphics_, x: number, y: number, w: number, h: number): void;
        abstract draw(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getPixelBufferFrameCount(): number;
        copy(): this;
        createPixelBuffer(): Internal.PixelBuffer;
        getJson(): Internal.JsonElement;
        get empty(): boolean
        get ingredient(): any
        get pixelBufferFrameCount(): number
        get json(): Internal.JsonElement
    }
    type Icon_ = Icon;
    class ResourceOrTagKeyArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.ResourceOrTagKeyArgument<T>> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.ResourceOrTagKeyArgument<T>;
        type(): Internal.ArgumentTypeInfo<Internal.ResourceOrTagKeyArgument<T>, any>;
    }
    type ResourceOrTagKeyArgument$Info$Template_ = ResourceOrTagKeyArgument$Info$Template;
    class ActionRegistryEntry extends Internal.Record {
        constructor(prototype: Internal.HexPattern_, action: Internal.Action_)
        prototype(): Internal.HexPattern;
        action(): Internal.Action;
    }
    type ActionRegistryEntry_ = Special.Action | ActionRegistryEntry;
    class FurnaceBlock extends Internal.AbstractFurnaceBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FurnaceBlock_ = FurnaceBlock;
    class AtomicReferenceArray <E> implements Internal.Serializable {
        constructor(arg0: E[])
        constructor(arg0: number)
        compareAndExchangeAcquire(arg0: number, arg1: E, arg2: E): E;
        compareAndExchangeRelease(arg0: number, arg1: E, arg2: E): E;
        get(arg0: number): E;
        weakCompareAndSetPlain(arg0: number, arg1: E, arg2: E): boolean;
        weakCompareAndSetVolatile(arg0: number, arg1: E, arg2: E): boolean;
        setPlain(arg0: number, arg1: E): void;
        set(arg0: number, arg1: E): void;
        setOpaque(arg0: number, arg1: E): void;
        compareAndExchange(arg0: number, arg1: E, arg2: E): E;
        weakCompareAndSetAcquire(arg0: number, arg1: E, arg2: E): boolean;
        getPlain(arg0: number): E;
        setRelease(arg0: number, arg1: E): void;
        getAndUpdate(arg0: number, arg1: Internal.UnaryOperator_<E>): E;
        updateAndGet(arg0: number, arg1: Internal.UnaryOperator_<E>): E;
        compareAndSet(arg0: number, arg1: E, arg2: E): boolean;
        lazySet(arg0: number, arg1: E): void;
        /**
         * @deprecated
        */
        weakCompareAndSet(arg0: number, arg1: E, arg2: E): boolean;
        getAndSet(arg0: number, arg1: E): E;
        getAcquire(arg0: number): E;
        getOpaque(arg0: number): E;
        accumulateAndGet(arg0: number, arg1: E, arg2: Internal.BinaryOperator_<E>): E;
        getAndAccumulate(arg0: number, arg1: E, arg2: Internal.BinaryOperator_<E>): E;
        weakCompareAndSetRelease(arg0: number, arg1: E, arg2: E): boolean;
        length(): number;
    }
    type AtomicReferenceArray_<E> = AtomicReferenceArray<E>;
    interface TransactionContext$CloseCallback {
        abstract onClose(arg0: Internal.TransactionContext_, arg1: Internal.TransactionContext$Result_): void;
        (arg0: Internal.TransactionContext, arg1: Internal.TransactionContext$Result): void;
    }
    type TransactionContext$CloseCallback_ = TransactionContext$CloseCallback;
    interface SpawnPlacements$SpawnPredicate <T extends Internal.Entity> {
        abstract test(arg0: Internal.EntityType_<T>, arg1: Internal.ServerLevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        (arg0: Internal.EntityType<T>, arg1: Internal.ServerLevelAccessor, arg2: Internal.MobSpawnType, arg3: BlockPos, arg4: Internal.RandomSource): boolean;
    }
    type SpawnPlacements$SpawnPredicate_<T extends Internal.Entity> = SpawnPlacements$SpawnPredicate<T>;
    class PowerUnits extends Internal.Enum<Internal.PowerUnits> {
        convertTo(target: Internal.PowerUnits_, value: number): number;
        static valueOf(name: string): Internal.PowerUnits;
        static values(): Internal.PowerUnits[];
        textComponent(): net.minecraft.network.chat.Component;
        getSymbolName(): string;
        get symbolName(): string
        conversionRatio: number;
        static readonly TR: Internal.PowerUnits;
        readonly unlocalizedName: string;
        static readonly AE: Internal.PowerUnits;
        readonly symbolName: string;
    }
    type PowerUnits_ = PowerUnits | "tr" | "ae";
    class BooleanProperty extends Internal.Property<boolean> {
        getName($$0: boolean): string;
        static create($$0: string): Internal.BooleanProperty;
        getPossibleValues(): Internal.Collection<boolean>;
        getValue($$0: string): Internal.Optional<boolean>;
        get possibleValues(): Internal.Collection<boolean>
    }
    type BooleanProperty_ = BooleanProperty;
    class FabricDataGenerator$Pack extends Internal.DataGenerator$PackGenerator {
        addProvider<T extends Internal.DataProvider>(factory: Internal.FabricDataGenerator$Pack$RegistryDependentFactory_<T>): T;
        addProvider<T extends Internal.DataProvider>(factory: Internal.FabricDataGenerator$Pack$Factory_<T>): T;
    }
    type FabricDataGenerator$Pack_ = FabricDataGenerator$Pack;
    class ForkingTrunkPlacer extends Internal.TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number)
        static readonly CODEC: Internal.Codec<Internal.ForkingTrunkPlacer>;
    }
    type ForkingTrunkPlacer_ = ForkingTrunkPlacer;
    interface CustomPayloadC2SPacketAccessor {
        abstract getData(): Internal.FriendlyByteBuf;
        abstract getChannel(): ResourceLocation;
        get data(): Internal.FriendlyByteBuf
        get channel(): ResourceLocation
    }
    type CustomPayloadC2SPacketAccessor_ = CustomPayloadC2SPacketAccessor;
    class ChuteItem extends Internal.BlockItem {
        constructor(p_i48527_1_: Internal.Block_, p_i48527_2_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ChuteItem_ = ChuteItem;
    class Biome$Precipitation extends Internal.Enum<Internal.Biome$Precipitation> {
        static valueOf($$0: string): Internal.Biome$Precipitation;
        static values(): Internal.Biome$Precipitation[];
        static readonly RAIN: Internal.Biome$Precipitation;
        static readonly NONE: Internal.Biome$Precipitation;
        static readonly SNOW: Internal.Biome$Precipitation;
    }
    type Biome$Precipitation_ = "snow" | "rain" | Biome$Precipitation | "none";
    class BeltTunnelBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.BeltTunnelBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.BeltTunnelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.BeltTunnelBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        isValidPositionForPlacement(state: Internal.BlockState_, worldIn: Internal.LevelReader_, pos: BlockPos_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static isJunction(state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.BeltTunnelBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        updateTunnel(world: Internal.LevelAccessor_, pos: BlockPos_): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isStraight(state: Internal.BlockState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.BeltTunnelBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.BeltTunnelBlockEntity;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static hasWindow(state: Internal.BlockState_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.BeltTunnelBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.BeltTunnelBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.BeltTunnelBlockEntity
        static readonly SHAPE: Internal.Property<Internal.BeltTunnelBlock$Shape>;
        static readonly HORIZONTAL_AXIS: Internal.Property<Internal.Direction$Axis>;
    }
    type BeltTunnelBlock_ = BeltTunnelBlock;
    interface DOMImplementation {
        abstract hasFeature(arg0: string, arg1: string): boolean;
        abstract createDocument(arg0: string, arg1: string, arg2: Internal.DocumentType_): Internal.Document;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract createDocumentType(arg0: string, arg1: string, arg2: string): Internal.DocumentType;
    }
    type DOMImplementation_ = DOMImplementation;
    class TransformCircumstance {
        constructor(type: string)
        isFluidTag(tag: Internal.TagKey_<Internal.Fluid>): boolean;
        static explosion(): Internal.TransformCircumstance;
        isFluid(): boolean;
        static fluid(tag: Internal.TagKey_<Internal.Fluid>): Internal.TransformCircumstance;
        isExplosion(): boolean;
        isFluid(fluid: Internal.Fluid_): boolean;
        getFluidsForRendering(): Internal.List<Internal.Fluid>;
        toJson(): Internal.JsonObject;
        isFluid(state: Internal.FluidState_): boolean;
        get fluid(): boolean
        get explosion(): boolean
        get fluidsForRendering(): Internal.List<Internal.Fluid>
        static readonly EXPLOSION: Internal.TransformCircumstance;
    }
    type TransformCircumstance_ = TransformCircumstance;
    interface TriFunction <T, U, P, R> {
        andThen<V>(after: Internal.Function_<R, V>): Internal.TriFunction<T, U, P, V>;
        abstract apply(arg0: T, arg1: U, arg2: P): R;
        (arg0: T, arg1: U, arg2: P): R;
    }
    type TriFunction_<T, U, P, R> = TriFunction<T, U, P, R>;
    class SnorkelItem extends Internal.MobEffectItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SnorkelItem_ = SnorkelItem;
    abstract class ValueObject {
        constructor()
    }
    type ValueObject_ = ValueObject;
    class EnumMap <K extends Internal.Enum<K>, V> extends Internal.AbstractMap<K, V> implements Internal.Cloneable, Internal.Serializable {
        constructor(arg0: Internal.Map_<K, V>)
        constructor(arg0: K)
        constructor(arg0: Internal.EnumMap_<K, V>)
        clone(): any;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        put(arg0: any, arg1: any): any;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type EnumMap_<K extends Internal.Enum<K>, V> = EnumMap<K, V>;
    interface FocusNavigationEvent {
        abstract getVerticalDirectionForInitialFocus(): Internal.ScreenDirection;
        get verticalDirectionForInitialFocus(): Internal.ScreenDirection
        (): Internal.ScreenDirection_;
    }
    type FocusNavigationEvent_ = FocusNavigationEvent;
    interface IntrinsicEnchantItem {
        abstract getIntrinsicEnchantLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        (arg0: Internal.ItemStack, arg1: Internal.Enchantment): number;
    }
    type IntrinsicEnchantItem_ = IntrinsicEnchantItem;
    interface Chronology extends Internal.Comparable<Internal.Chronology> {
        abstract eras(): Internal.List<Internal.Era>;
        dateNow(arg0: Internal.ZoneId_): Internal.ChronoLocalDate;
        from(arg0: Internal.TemporalAccessor_): this;
        localDateTime(arg0: Internal.TemporalAccessor_): Internal.ChronoLocalDateTime<Internal.ChronoLocalDate>;
        zonedDateTime(arg0: Internal.Instant_, arg1: Internal.ZoneId_): Internal.ChronoZonedDateTime<Internal.ChronoLocalDate>;
        compareTo(arg0: any): number;
        abstract resolveDate(arg0: Internal.Map_<Internal.TemporalField, number>, arg1: Internal.ResolverStyle_): Internal.ChronoLocalDate;
        dateNow(arg0: Internal.Clock_): Internal.ChronoLocalDate;
        abstract getCalendarType(): string;
        isIsoBased(): boolean;
        abstract compareTo(arg0: Internal.Chronology_): number;
        of(arg0: string): this;
        abstract range(arg0: Internal.ChronoField_): Internal.ValueRange;
        abstract date(arg0: number, arg1: number, arg2: number): Internal.ChronoLocalDate;
        abstract prolepticYear(arg0: Internal.Era_, arg1: number): number;
        abstract toString(): string;
        abstract eraOf(arg0: number): Internal.Era;
        period(arg0: number, arg1: number, arg2: number): Internal.ChronoPeriod;
        epochSecond(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.ZoneOffset_): number;
        getAvailableChronologies(): Internal.Set<Internal.Chronology>;
        abstract getId(): string;
        abstract isLeapYear(arg0: number): boolean;
        dateYearDay(arg0: Internal.Era_, arg1: number, arg2: number): Internal.ChronoLocalDate;
        getDisplayName(arg0: Internal.TextStyle_, arg1: Internal.Locale_): string;
        zonedDateTime(arg0: Internal.TemporalAccessor_): Internal.ChronoZonedDateTime<Internal.ChronoLocalDate>;
        abstract date(arg0: Internal.TemporalAccessor_): Internal.ChronoLocalDate;
        abstract hashCode(): number;
        abstract dateEpochDay(arg0: number): Internal.ChronoLocalDate;
        abstract dateYearDay(arg0: number, arg1: number): Internal.ChronoLocalDate;
        date(arg0: Internal.Era_, arg1: number, arg2: number, arg3: number): Internal.ChronoLocalDate;
        abstract equals(arg0: any): boolean;
        epochSecond(arg0: Internal.Era_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: Internal.ZoneOffset_): number;
        ofLocale(arg0: Internal.Locale_): this;
        dateNow(): Internal.ChronoLocalDate;
        get calendarType(): string
        get isoBased(): boolean
        get availableChronologies(): Internal.Set<Internal.Chronology>
        get id(): string
    }
    type Chronology_ = Chronology;
    class HotCocoaItem extends Internal.DrinkableItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HotCocoaItem_ = HotCocoaItem;
    class ClientboundPlayerInfoUpdatePacket$Action extends Internal.Enum<Internal.ClientboundPlayerInfoUpdatePacket$Action> {
        static values(): Internal.ClientboundPlayerInfoUpdatePacket$Action[];
        static valueOf($$0: string): Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly UPDATE_DISPLAY_NAME: Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly INITIALIZE_CHAT: Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly UPDATE_LISTED: Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly UPDATE_GAME_MODE: Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly ADD_PLAYER: Internal.ClientboundPlayerInfoUpdatePacket$Action;
        static readonly UPDATE_LATENCY: Internal.ClientboundPlayerInfoUpdatePacket$Action;
    }
    type ClientboundPlayerInfoUpdatePacket$Action_ = "update_game_mode" | "update_display_name" | ClientboundPlayerInfoUpdatePacket$Action | "update_latency" | "initialize_chat" | "update_listed" | "add_player";
    interface Mutable <T> {
        abstract setValue(arg0: T): void;
        abstract getValue(): T;
        set value(arg0: T)
        get value(): T
    }
    type Mutable_<T> = Mutable<T>;
    class InputConstants$Type extends Internal.Enum<Internal.InputConstants$Type> {
        getOrCreate($$0: number): Internal.InputConstants$Key;
        static valueOf($$0: string): Internal.InputConstants$Type;
        static values(): Internal.InputConstants$Type[];
        static readonly KEYSYM: Internal.InputConstants$Type;
        static readonly MOUSE: Internal.InputConstants$Type;
        static readonly SCANCODE: Internal.InputConstants$Type;
    }
    type InputConstants$Type_ = "keysym" | "mouse" | InputConstants$Type | "scancode";
    class ChunkLoaderBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ChunkLoaderBlock_ = ChunkLoaderBlock;
    interface ISpeedControllerAdapter {
        abstract getTargetSpeed(): number;
        abstract setTargetSpeed(arg0: number): void;
        get targetSpeed(): number
        set targetSpeed(arg0: number)
    }
    type ISpeedControllerAdapter_ = ISpeedControllerAdapter;
    class FluixPickaxeItem extends Internal.PickaxeItem implements Internal.IntrinsicEnchantItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getIntrinsicEnchantLevel(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FluixPickaxeItem_ = FluixPickaxeItem;
    class BigDripleafBlock extends Internal.HorizontalDirectionalBlock implements Internal.SimpleWaterloggedBlock, Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        static placeWithRandomHeight($$0: Internal.LevelAccessor_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.Direction_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BigDripleafBlock_ = BigDripleafBlock;
    class RedwoodTreeFeature extends Internal.BOPTreeFeature<Internal.TaigaTreeConfiguration> {
        constructor(codec: Internal.Codec_<Internal.TaigaTreeConfiguration>)
        generateLeafLayer(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, leavesRadius: number, trunkStart: number, trunkEnd: number, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.TaigaTreeConfiguration_): void;
        checkSpace(world: Internal.LevelAccessor_, pos: BlockPos_, baseHeight: number, height: number, config: Internal.TaigaTreeConfiguration_): boolean;
        generateBranch(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, direction: Internal.Direction_, length: number, logs: Internal.BiConsumer_<BlockPos, Internal.BlockState>, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.TaigaTreeConfiguration_): void;
    }
    type RedwoodTreeFeature_ = RedwoodTreeFeature;
    class HikerEnchantment extends Internal.Enchantment {
        constructor()
        registryName(): string;
    }
    type HikerEnchantment_ = HikerEnchantment;
    interface AccessorMob {
        abstract bookshelf$getAmbientSound(): Internal.SoundEvent;
        (): Internal.SoundEvent_;
    }
    type AccessorMob_ = AccessorMob;
    interface IntCollection extends Internal.IntIterable, Internal.Collection<number> {
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        abstract isEmpty(): boolean;
        abstract contains(arg0: number): boolean;
        abstract toIntArray(): number[];
        forEach(arg0: Internal.IntConsumer_): void;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        intStream(): Internal.IntStream;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        abstract toArray(arg0: number[]): number[];
        intParallelStream(): Internal.IntStream;
        abstract removeAll(arg0: Internal.IntCollection_): boolean;
        intIterator(): Internal.IntIterator;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        abstract iterator(): Internal.IntIterator;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        abstract addAll(arg0: Internal.IntCollection_): boolean;
        abstract retainAll(arg0: Internal.IntCollection_): boolean;
        forEach(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        abstract add(arg0: number): boolean;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        abstract containsAll(arg0: Internal.IntCollection_): boolean;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        toIntArray(arg0: number[]): number[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.ints.IntPredicate_): boolean;
        abstract toArray(): any[];
        intSpliterator(): Internal.IntSpliterator;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract rem(arg0: number): boolean;
        abstract clear(): void;
        abstract equals(arg0: any): boolean;
        get empty(): boolean
    }
    type IntCollection_ = IntCollection;
    class ShapedDurabilityRecipe$Serializer implements Internal.RecipeSerializer<Internal.ShapedDurabilityRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ShapedDurabilityRecipe;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.ShapedDurabilityRecipe_): void;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.ShapedDurabilityRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type ShapedDurabilityRecipe$Serializer_ = ShapedDurabilityRecipe$Serializer;
    class AddLakeProperties {
        constructor()
        setInner(p: BlockStatePredicate_): void;
        setOuter(p: BlockStatePredicate_): void;
        set inner(p: BlockStatePredicate_)
        set outer(p: BlockStatePredicate_)
        retrogen: number;
        barrier: BlockStatePredicate;
        worldgenLayer: Internal.GenerationStep$Decoration;
        chance: number;
        biomes: Internal.BiomeFilter;
        id: ResourceLocation;
        fluid: BlockStatePredicate;
    }
    type AddLakeProperties_ = AddLakeProperties;
    class BlastFurnaceBlockEntity extends Internal.AbstractFurnaceBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isSleeping(): boolean;
        setChanged(): void;
        onLoad(): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        setRecipeUsed($$0: Internal.Level_, $$1: Internal.ServerPlayer_, $$2: Internal.Recipe_<any>): boolean;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get sleeping(): boolean
        get width(): number
        get maxStackSize(): number
        set ticker(delegate: Internal.TickingBlockEntity_)
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type BlastFurnaceBlockEntity_ = BlastFurnaceBlockEntity;
    class MechanicalPressBlockEntity extends Internal.BasinOperatingBlockEntity implements Internal.PressingBehaviour$PressingBehaviourSpecifics {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        tryProcessInBasin(simulate: boolean): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getKineticSpeed(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        onItemPressed(result: Internal.ItemStack_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getRecipe(item: Internal.ItemStack_): Internal.Optional<Internal.PressingRecipe>;
        onPressingCompleted(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        static canCompress<C extends net.minecraft.world.Container>(recipe: Internal.Recipe_<C>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        tryProcessInWorld(itemEntity: Internal.ItemEntity_, simulate: boolean): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        tryProcessOnBelt(input: Internal.TransportedItemStack_, outputList: Internal.List_<Internal.ItemStack>, simulate: boolean): boolean;
        getPressingBehaviour(): Internal.PressingBehaviour;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getParticleAmount(): number;
        canProcessInBulk(): boolean;
        getRenderBoundingBox(): Internal.AABB;
        get kineticSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        get pressingBehaviour(): Internal.PressingBehaviour
        get particleAmount(): number
        get renderBoundingBox(): Internal.AABB
        pressingBehaviour: Internal.PressingBehaviour;
    }
    type MechanicalPressBlockEntity_ = MechanicalPressBlockEntity;
    class ClockworkBearingBlock extends Internal.BearingBlock implements Internal.IBE<Internal.ClockworkBearingBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityClass(): typeof Internal.ClockworkBearingBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ClockworkBearingBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ClockworkBearingBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ClockworkBearingBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ClockworkBearingBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        setDestroySpeed(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ClockworkBearingBlockEntity>): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.ClockworkBearingBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.ClockworkBearingBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type ClockworkBearingBlock_ = ClockworkBearingBlock;
    class SnowblossomLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type SnowblossomLeavesBlock_ = SnowblossomLeavesBlock;
    class FuzzyMode extends Internal.Enum<Internal.FuzzyMode> {
        static values(): Internal.FuzzyMode[];
        calculateBreakPoint(maxDamage: number): number;
        static valueOf(name: string): Internal.FuzzyMode;
        readonly percentage: number;
        static readonly PERCENT_50: Internal.FuzzyMode;
        readonly breakPoint: number;
        static readonly IGNORE_ALL: Internal.FuzzyMode;
        static readonly PERCENT_99: Internal.FuzzyMode;
        static readonly PERCENT_75: Internal.FuzzyMode;
        static readonly PERCENT_25: Internal.FuzzyMode;
    }
    type FuzzyMode_ = "percent_99" | "percent_25" | FuzzyMode | "ignore_all" | "percent_50" | "percent_75";
    class FluidListDisplaySource extends Internal.ValueListDisplaySource {
        constructor()
    }
    type FluidListDisplaySource_ = FluidListDisplaySource;
    class TypeWrappers {
        constructor()
        registerSimple<T>(target: T, factory: Internal.TypeWrapperFactory$Simple_<T>): void;
        register<T>(target: T, validator: Internal.Predicate_<any>, factory: Internal.TypeWrapperFactory_<T>): void;
        register<T>(target: T, factory: Internal.TypeWrapperFactory_<T>): void;
        getWrapperFactory(target: typeof any, from: any): Internal.TypeWrapperFactory<any>;
        registerSimple<T>(target: T, validator: Internal.Predicate_<any>, factory: Internal.TypeWrapperFactory$Simple_<T>): void;
    }
    type TypeWrappers_ = TypeWrappers;
    class ReversedBuffer {
        constructor()
        applyChainWaveBuffer(...boxes: any_[]): void;
        calculateChainWaveBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, entity: Internal.LivingEntity_): void;
        calculateChainSwingBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, entity: Internal.LivingEntity_): void;
        applyChainSwingBuffer(...boxes: any_[]): void;
        resetRotations(): void;
        calculateChainWaveBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, divisor: number, entity: Internal.LivingEntity_): void;
        calculateChainSwingBuffer(maxAngle: number, bufferTime: number, angleDecrement: number, divisor: number, entity: Internal.LivingEntity_): void;
    }
    type ReversedBuffer_ = ReversedBuffer;
    class FeastBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_, servingItem: Internal.Supplier_<Internal.Item>, hasLeftovers: boolean)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getMaxServings(): number;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getServingsProperty(): Internal.IntegerProperty;
        setDestroySpeed(v: number): void;
        getServingItem(state: Internal.BlockState_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get maxServings(): number
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get servingsProperty(): Internal.IntegerProperty
        set destroySpeed(v: number)
        readonly servingItem: Internal.Supplier<Internal.Item>;
        readonly hasLeftovers: boolean;
        static readonly FACING: Internal.DirectionProperty;
        static readonly SERVINGS: Internal.IntegerProperty;
    }
    type FeastBlock_ = FeastBlock;
    class DataResult <R> implements Internal.App<Internal.DataResult$Mu, R> {
        get(): Internal.Either<R, Internal.DataResult$PartialResult<R>>;
        static success<R>(arg0: R): Internal.DataResult<R>;
        addLifecycle(arg0: Internal.Lifecycle_): this;
        error(): Internal.Optional<Internal.DataResult$PartialResult<R>>;
        static instance(): Internal.DataResult$Instance;
        static error<R>(arg0: Internal.Supplier_<string>): Internal.DataResult<R>;
        setPartial(arg0: Internal.Supplier_<R>): this;
        result(): Internal.Optional<R>;
        static partialGet<K, V>(arg0: Internal.Function_<K, V>, arg1: Internal.Supplier_<string>): Internal.Function<K, Internal.DataResult<V>>;
        static unbox<R>(arg0: Internal.App_<Internal.DataResult$Mu, R>): Internal.DataResult<R>;
        apply2stable<R2, S>(arg0: Internal.BiFunction_<R, R2, S>, arg1: Internal.DataResult_<R2>): Internal.DataResult<S>;
        static error<R>(arg0: Internal.Supplier_<string>, arg1: Internal.Lifecycle_): Internal.DataResult<R>;
        ap<R2>(arg0: Internal.DataResult_<Internal.Function<R, R2>>): Internal.DataResult<R2>;
        static error<R>(arg0: Internal.Supplier_<string>, arg1: R, arg2: Internal.Lifecycle_): Internal.DataResult<R>;
        static success<R>(arg0: R, arg1: Internal.Lifecycle_): Internal.DataResult<R>;
        mapError(arg0: Internal.UnaryOperator_<string>): this;
        lifecycle(): Internal.Lifecycle;
        setPartial(arg0: R): this;
        apply3<R2, R3, S>(arg0: Internal.Function3_<R, R2, R3, S>, arg1: Internal.DataResult_<R2>, arg2: Internal.DataResult_<R3>): Internal.DataResult<S>;
        resultOrPartial(arg0: Internal.Consumer_<string>): Internal.Optional<R>;
        setLifecycle(arg0: Internal.Lifecycle_): this;
        map<T>(arg0: Internal.Function_<R, T>): Internal.DataResult<T>;
        static error<R>(arg0: Internal.Supplier_<string>, arg1: R): Internal.DataResult<R>;
        flatMap<R2>(arg0: Internal.Function_<R, Internal.DataResult<R2>>): Internal.DataResult<R2>;
        apply2<R2, S>(arg0: Internal.BiFunction_<R, R2, S>, arg1: Internal.DataResult_<R2>): Internal.DataResult<S>;
        getOrThrow(arg0: boolean, arg1: Internal.Consumer_<string>): R;
        promotePartial(arg0: Internal.Consumer_<string>): this;
        set partial(arg0: Internal.Supplier_<R>)
        set partial(arg0: R)
        set lifecycle(arg0: Internal.Lifecycle_)
    }
    type DataResult_<R> = DataResult<R>;
    interface ScreenEvents$BeforeTick {
        abstract beforeTick(arg0: Internal.Screen_): void;
        (arg0: Internal.Screen): void;
    }
    type ScreenEvents$BeforeTick_ = ScreenEvents$BeforeTick;
    class SpiderEggBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        spawnSpider(p_154567_: Internal.Level_, p_154569_: BlockPos_): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SpiderEggBlock_ = SpiderEggBlock;
    class CableModemVariant extends Internal.Enum<Internal.CableModemVariant> implements Internal.StringRepresentable {
        static from(facing: Internal.Direction_): Internal.CableModemVariant;
        getFacing(): Internal.Direction;
        static valueOf(name: string): Internal.CableModemVariant;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static from(facing: Internal.Direction_, modem: boolean, peripheral: boolean): Internal.CableModemVariant;
        isModemOn(): boolean;
        isPeripheralOn(): boolean;
        static values(): Internal.CableModemVariant[];
        get facing(): Internal.Direction
        get serializedName(): string
        get modemOn(): boolean
        get peripheralOn(): boolean
        static readonly WestOff: Internal.CableModemVariant;
        static readonly WestOnPeripheral: Internal.CableModemVariant;
        static readonly EastOffPeripheral: Internal.CableModemVariant;
        static readonly EastOff: Internal.CableModemVariant;
        static readonly EastOn: Internal.CableModemVariant;
        static readonly SouthOn: Internal.CableModemVariant;
        static readonly WestOn: Internal.CableModemVariant;
        static readonly DownOffPeripheral: Internal.CableModemVariant;
        static readonly SouthOnPeripheral: Internal.CableModemVariant;
        static readonly UpOnPeripheral: Internal.CableModemVariant;
        static readonly NorthOnPeripheral: Internal.CableModemVariant;
        static readonly NorthOffPeripheral: Internal.CableModemVariant;
        static readonly UpOn: Internal.CableModemVariant;
        static readonly SouthOffPeripheral: Internal.CableModemVariant;
        static readonly NorthOff: Internal.CableModemVariant;
        static readonly SouthOff: Internal.CableModemVariant;
        static readonly None: Internal.CableModemVariant;
        static readonly UpOffPeripheral: Internal.CableModemVariant;
        static readonly EastOnPeripheral: Internal.CableModemVariant;
        static readonly UpOff: Internal.CableModemVariant;
        static readonly NorthOn: Internal.CableModemVariant;
        static readonly WestOffPeripheral: Internal.CableModemVariant;
        static readonly DownOff: Internal.CableModemVariant;
        static readonly DownOnPeripheral: Internal.CableModemVariant;
        static readonly DownOn: Internal.CableModemVariant;
    }
    type CableModemVariant_ = CableModemVariant | "southoff" | "northoff" | "upoff" | "westoffperipheral" | "none" | "northonperipheral" | "westoff" | "eastoffperipheral" | "downoffperipheral" | "eastoff" | "southon" | "eastonperipheral" | "westonperipheral" | "downonperipheral" | "downon" | "southoffperipheral" | "weston" | "southonperipheral" | "downoff" | "upoffperipheral" | "northon" | "northoffperipheral" | "easton" | "upon" | "uponperipheral";
    class BlackSandSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(p_65811_: Internal.LevelSimulatedReader_, p_65812_: BlockPos_): boolean;
    }
    type BlackSandSplatterFeature_ = BlackSandSplatterFeature;
    class OvergrownSandBlock extends Internal.FallingBlock implements Internal.BonemealableBlock {
        constructor(dustColor: number, properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(p_153802_: Internal.Level_, p_153803_: Internal.RandomSource_, p_153804_: BlockPos_, p_153805_: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        performBonemeal(p_221270_: Internal.ServerLevel_, p_221271_: Internal.RandomSource_, p_221272_: BlockPos_, p_221273_: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(p_153797_: Internal.LevelReader_, p_153798_: BlockPos_, p_153799_: Internal.BlockState_, b: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type OvergrownSandBlock_ = OvergrownSandBlock;
    class ItemExtendedStaff extends Internal.ItemStaff {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly GRID_ZOOM: Internal.AttributeModifier;
    }
    type ItemExtendedStaff_ = ItemExtendedStaff;
    interface HeightProviderType <P extends Internal.HeightProvider> {
        abstract codec(): Internal.Codec<P>;
        (): Internal.Codec_<P>;
        readonly UNIFORM: Internal.HeightProviderType<Internal.UniformHeight>;
        readonly CONSTANT: Internal.HeightProviderType<Internal.ConstantHeight>;
        readonly WEIGHTED_LIST: Internal.HeightProviderType<Internal.WeightedListHeight>;
        readonly VERY_BIASED_TO_BOTTOM: Internal.HeightProviderType<Internal.VeryBiasedToBottomHeight>;
        readonly TRAPEZOID: Internal.HeightProviderType<Internal.TrapezoidHeight>;
        readonly BIASED_TO_BOTTOM: Internal.HeightProviderType<Internal.BiasedToBottomHeight>;
    }
    type HeightProviderType_<P extends Internal.HeightProvider> = Special.HeightProviderType | HeightProviderType<P>;
    class AllArmInteractionPointTypes$RespawnAnchorType extends Internal.ArmInteractionPointType {
        constructor()
    }
    type AllArmInteractionPointTypes$RespawnAnchorType_ = AllArmInteractionPointTypes$RespawnAnchorType;
    class Model$ConfiguredMesh extends Internal.Record {
        constructor(material: dev.engine_room.flywheel.api.material.Material_, mesh: dev.engine_room.flywheel.api.model.Mesh_)
        material(): dev.engine_room.flywheel.api.material.Material;
        mesh(): dev.engine_room.flywheel.api.model.Mesh;
    }
    type Model$ConfiguredMesh_ = Model$ConfiguredMesh;
    class MoonWalkerEnchantment extends Internal.Enchantment {
        constructor()
        registryName(): string;
    }
    type MoonWalkerEnchantment_ = MoonWalkerEnchantment;
    class MoltenZincFluid$Flowing extends Internal.MoltenZincFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenZincFluid$Flowing_ = MoltenZincFluid$Flowing;
    abstract class FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_)
        createFoliage($$0: Internal.LevelSimulatedReader_, $$1: Internal.FoliagePlacer$FoliageSetter_, $$2: Internal.RandomSource_, $$3: Internal.TreeConfiguration_, $$4: number, $$5: Internal.FoliagePlacer$FoliageAttachment_, $$6: number, $$7: number): void;
        abstract foliageHeight(arg0: Internal.RandomSource_, arg1: number, arg2: Internal.TreeConfiguration_): number;
        foliageRadius($$0: Internal.RandomSource_, $$1: number): number;
        static readonly CODEC: Internal.Codec<Internal.FoliagePlacer>;
    }
    type FoliagePlacer_ = FoliagePlacer;
    interface ProperWaterloggedBlock extends Internal.SimpleWaterloggedBlock {
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type ProperWaterloggedBlock_ = ProperWaterloggedBlock;
    interface TransformStack <Self extends Internal.TransformStack<Self>> extends Internal.Transform<Self> {
        abstract pushPose(): Self;
        rotateTo(from: Internal.Direction_, to: Internal.Direction_): Self;
        rotateZDegrees(degrees: number): Self;
        of(stack: Internal.PoseStack_): Internal.PoseTransformStack;
        rotateX(radians: number): Self;
        scale(factors: Internal.Vector3fc_): Self;
        rotateCentered(radians: number, axis: Internal.Direction_): Self;
        rotateCentered(radians: number, axis: Internal.Direction$Axis_): Self;
        translateBack(vec: Vec3d_): Self;
        rotateDegrees(degrees: number, axis: Internal.Axis_): Self;
        translateY(y: number): Self;
        rotateZ(radians: number): Self;
        scaleZ(factor: number): Self;
        rotateCenteredDegrees(degrees: number, axis: Internal.Axis_): Self;
        abstract scale(arg0: number, arg1: number, arg2: number): Self;
        rotate(radians: number, axis: Internal.Direction$Axis_): Self;
        rotateDegrees(degrees: number, axisX: number, axisY: number, axisZ: number): Self;
        rotateCenteredDegrees(degrees: number, axisX: number, axisY: number, axisZ: number): Self;
        translateBack(x: number, y: number, z: number): Self;
        rotateAround(quaternion: Internal.Quaternionfc_, x: number, y: number, z: number): Self;
        rotate(radians: number, axis: Internal.Direction_): Self;
        rotate(radians: number, axis: Internal.Vector3fc_): Self;
        rotateTo(fromX: number, fromY: number, fromZ: number, toX: number, toY: number, toZ: number): Self;
        rotateCentered(radians: number, axis: Internal.Vector3fc_): Self;
        rotateZCenteredDegrees(degrees: number): Self;
        translate(vec: Internal.Vector3fc_): Self;
        rotateXDegrees(degrees: number): Self;
        rotateXCentered(radians: number): Self;
        translateBack(x: number, y: number, z: number): Self;
        abstract mulNormal(arg0: Internal.Matrix3fc_): Self;
        rotateCenteredDegrees(degrees: number, axis: Internal.Direction$Axis_): Self;
        rotate(axisAngle: Internal.AxisAngle4f_): Self;
        translateBack(vec: Internal.Vector3ic_): Self;
        scaleX(factor: number): Self;
        abstract mulPose(arg0: Internal.Matrix4fc_): Self;
        rotateCentered(radians: number, axisX: number, axisY: number, axisZ: number): Self;
        rotateCenteredDegrees(degrees: number, axis: Internal.Direction_): Self;
        rotateCentered(radians: number, axis: Internal.Axis_): Self;
        rotateTo(from: Internal.Vector3fc_, to: Internal.Vector3fc_): Self;
        rotateXCenteredDegrees(degrees: number): Self;
        translate(v: number): Self;
        rotateYDegrees(degrees: number): Self;
        abstract popPose(): Self;
        abstract rotate(arg0: Internal.Quaternionfc_): Self;
        center(): Self;
        translateBack(v: number): Self;
        rotateYCentered(radians: number): Self;
        rotateDegrees(degrees: number, axis: Internal.Direction$Axis_): Self;
        rotateY(radians: number): Self;
        rotateDegrees(degrees: number, axis: Internal.Vector3fc_): Self;
        rotateDegrees(degrees: number, axis: Internal.Direction_): Self;
        translateZ(z: number): Self;
        scaleY(factor: number): Self;
        translateX(x: number): Self;
        transform(pose: Internal.PoseStack$Pose_): Self;
        transform(pose: Internal.Matrix4fc_, normal: Internal.Matrix3fc_): Self;
        scale(factor: number): Self;
        transform(stack: Internal.PoseStack_): Self;
        translateBack(vec: Vec3i_): Self;
        translateBack(vec: Internal.Vector3fc_): Self;
        rotate(radians: number, axis: Internal.Axis_): Self;
        translate(x: number, y: number, z: number): Self;
        rotateCentered(q: Internal.Quaternionfc_): Self;
        nudge(seed: number): Self;
        uncenter(): Self;
        rotateCenteredDegrees(degrees: number, axis: Internal.Vector3fc_): Self;
        rotateYCenteredDegrees(degrees: number): Self;
        rotateZCentered(radians: number): Self;
        rotateAround(quaternion: Internal.Quaternionfc_, vec: Internal.Vector3fc_): Self;
        rotate(radians: number, axisX: number, axisY: number, axisZ: number): Self;
        abstract translate(arg0: number, arg1: number, arg2: number): Self;
        translate(vec: Vec3i_): Self;
        self(): Self;
        translate(vec: Vec3d_): Self;
        rotateToFace(facing: Internal.Direction_): Self;
        translate(vec: Internal.Vector3ic_): Self;
    }
    type TransformStack_<Self extends Internal.TransformStack<Self>> = TransformStack<Self>;
    class TrackEdgeIntersection {
        constructor()
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        targets(target1: Internal.TrackNodeLocation_, target2: Internal.TrackNodeLocation_): boolean;
        static read(nbt: Internal.CompoundTag_, dimensions: Internal.DimensionPalette_): Internal.TrackEdgeIntersection;
        isNear(location: number): boolean;
        id: Internal.UUID;
        target: Internal.Couple<Internal.TrackNodeLocation>;
        location: number;
        targetLocation: number;
        groupId: Internal.UUID;
    }
    type TrackEdgeIntersection_ = TrackEdgeIntersection;
    interface TimerCallback <T> {
        abstract handle(arg0: T, arg1: Internal.TimerQueue_<T>, arg2: number): void;
        (arg0: T, arg1: Internal.TimerQueue<T>, arg2: number): void;
    }
    type TimerCallback_<T> = TimerCallback<T>;
    class MoltenIronFluid$Flowing extends Internal.MoltenIronFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenIronFluid$Flowing_ = MoltenIronFluid$Flowing;
    class InputMethodHighlight {
        constructor(arg0: boolean, arg1: number, arg2: number)
        constructor(arg0: boolean, arg1: number)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: Internal.Map_<Internal.TextAttribute, any>)
        isSelected(): boolean;
        getStyle(): Internal.Map<Internal.TextAttribute, any>;
        getState(): number;
        getVariation(): number;
        get selected(): boolean
        get style(): Internal.Map<Internal.TextAttribute, any>
        get state(): number
        get variation(): number
        static readonly UNSELECTED_RAW_TEXT_HIGHLIGHT: Internal.InputMethodHighlight;
        static readonly CONVERTED_TEXT: 1;
        static readonly SELECTED_CONVERTED_TEXT_HIGHLIGHT: Internal.InputMethodHighlight;
        static readonly UNSELECTED_CONVERTED_TEXT_HIGHLIGHT: Internal.InputMethodHighlight;
        static readonly RAW_TEXT: 0;
        static readonly SELECTED_RAW_TEXT_HIGHLIGHT: Internal.InputMethodHighlight;
    }
    type InputMethodHighlight_ = InputMethodHighlight;
    interface ItemColor {
        abstract getColor(arg0: Internal.ItemStack_, arg1: number): number;
        (arg0: Internal.ItemStack, arg1: number): number;
    }
    type ItemColor_ = ItemColor;
    interface IExtendedPistonTile {
        abstract tickMovedBlock(arg0: Internal.Level_, arg1: BlockPos_): void;
        (arg0: Internal.Level, arg1: BlockPos): void;
    }
    type IExtendedPistonTile_ = IExtendedPistonTile;
    interface ScheduledFuture <V> extends Internal.Delayed, Internal.Future<V> {
        abstract get(): V;
        state(): Internal.Future$State;
        abstract getDelay(arg0: Internal.TimeUnit_): number;
        resultNow(): V;
        abstract compareTo(arg0: Internal.Delayed_): number;
        abstract get(arg0: number, arg1: Internal.TimeUnit_): V;
        abstract isDone(): boolean;
        abstract cancel(arg0: boolean): boolean;
        exceptionNow(): Internal.Throwable;
        abstract isCancelled(): boolean;
        get done(): boolean
        get cancelled(): boolean
    }
    type ScheduledFuture_<V> = ScheduledFuture<V>;
    class Matrix4x3d implements Internal.Cloneable, Internal.Externalizable, Internal.Matrix4x3dc {
        constructor(arg0: Internal.Matrix3fc_)
        constructor()
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number)
        constructor(arg0: Internal.Matrix4x3dc_)
        constructor(arg0: Internal.DoubleBuffer_)
        constructor(arg0: Internal.Matrix3dc_)
        constructor(arg0: Internal.Matrix4x3fc_)
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3dc_): this;
        mapnYXnZ(arg0: Internal.Matrix4x3d_): this;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        mapXZnY(arg0: Internal.Matrix4x3d_): this;
        reflect(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): this;
        translateLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        mapnYnZnX(): this;
        get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        mapYZnX(): this;
        transform(arg0: Internal.Vector4d_): Internal.Vector4d;
        rotationYXZ(arg0: number, arg1: number, arg2: number): this;
        mapnZXY(arg0: Internal.Matrix4x3d_): this;
        getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
        scaleLocal(arg0: number, arg1: number, arg2: number): this;
        origin(arg0: Internal.Vector3d_): Internal.Vector3d;
        rotationX(arg0: number): this;
        arcball(arg0: number, arg1: Internal.Vector3dc_, arg2: number, arg3: number): this;
        rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
        translateLocal(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): this;
        transformDirection(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        rotateYXZ(arg0: Internal.Vector3d_): this;
        translation(arg0: number, arg1: number, arg2: number): this;
        normal(arg0: Internal.Matrix4x3d_): this;
        scale(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        mapYnZnX(): this;
        normal(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        mapYXnZ(arg0: Internal.Matrix4x3d_): this;
        lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): this;
        mapYnXnZ(arg0: Internal.Matrix4x3d_): this;
        rotationZYX(arg0: number, arg1: number, arg2: number): this;
        rotateYXZ(arg0: number, arg1: number, arg2: number): this;
        normalize3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        mulTranslation(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): this;
        mapZnYX(): this;
        set3x3(arg0: Internal.Matrix4x3dc_): this;
        normalize3x3(arg0: Internal.Matrix4x3d_): this;
        fma(arg0: Internal.Matrix4x3dc_, arg1: number): this;
        rotateAround(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
        pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
        translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
        scale(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): this;
        rotationY(arg0: number): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        mapnYnXnZ(arg0: Internal.Matrix4x3d_): this;
        set(arg0: Internal.Matrix3fc_): this;
        set(arg0: number[], arg1: number): this;
        rotate(arg0: Internal.AxisAngle4d_, arg1: Internal.Matrix4x3d_): this;
        setLookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        mapZXY(arg0: Internal.Matrix4x3d_): this;
        setFloats(arg0: number, arg1: Internal.ByteBuffer_): this;
        mul(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        set3x3(arg0: Internal.Matrix3fc_): this;
        lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): this;
        obliqueZ(arg0: number, arg1: number, arg2: Internal.Matrix4x3d_): this;
        reflect(arg0: Internal.Quaterniondc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): this;
        rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        transformAab(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3d_, arg3: Internal.Vector3d_): this;
        get(arg0: Internal.Matrix4x3d_): this;
        get4x4(arg0: number[]): number[];
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        mapYnXZ(arg0: Internal.Matrix4x3d_): this;
        add(arg0: Internal.Matrix4x3fc_): this;
        cofactor3x3(arg0: Internal.Matrix4x3d_): this;
        rotate(arg0: number, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): this;
        transpose3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        isFinite(): boolean;
        m30(arg0: number): this;
        mapXnZnY(arg0: Internal.Matrix4x3d_): this;
        mapnYnXnZ(): this;
        transpose3x3(): this;
        getToAddress(arg0: number): Internal.Matrix4x3dc;
        setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapZYnX(): this;
        cofactor3x3(): this;
        obliqueZ(arg0: number, arg1: number): this;
        lerp(arg0: Internal.Matrix4x3dc_, arg1: number, arg2: Internal.Matrix4x3d_): this;
        mapnYZnX(arg0: Internal.Matrix4x3d_): this;
        scaleXY(arg0: number, arg1: number, arg2: Internal.Matrix4x3d_): this;
        mapnXnZnY(arg0: Internal.Matrix4x3d_): this;
        translate(arg0: number, arg1: number, arg2: number): this;
        setColumn(arg0: number, arg1: Internal.Vector3dc_): this;
        mapnZYX(arg0: Internal.Matrix4x3d_): this;
        mapnZnYX(): this;
        lookAtLH(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        mapnXZnY(arg0: Internal.Matrix4x3d_): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        mapnYXZ(arg0: Internal.Matrix4x3d_): this;
        get(arg0: number[], arg1: number): number[];
        set(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_, arg3: Internal.Vector3dc_): this;
        reflection(arg0: Internal.Quaterniondc_, arg1: Internal.Vector3dc_): this;
        rotateTranslation(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): this;
        mapYnXnZ(): this;
        m31(arg0: number): this;
        m02(): number;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        mapZXnY(): this;
        zero(): this;
        setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
        mapZnXY(): this;
        set3x3(arg0: Internal.Matrix3dc_): this;
        invertOrtho(arg0: Internal.Matrix4x3d_): this;
        translate(arg0: Internal.Vector3fc_): this;
        mapnYZnX(): this;
        sub(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): this;
        shadow(arg0: Internal.Vector4dc_, arg1: Internal.Matrix4x3dc_, arg2: Internal.Matrix4x3d_): this;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3d_): this;
        mapnXYnZ(arg0: Internal.Matrix4x3d_): this;
        scaleXY(arg0: number, arg1: number): this;
        mapYnZnX(arg0: Internal.Matrix4x3d_): this;
        mapnZnYX(arg0: Internal.Matrix4x3d_): this;
        translationRotateScale(arg0: Internal.Vector3dc_, arg1: Internal.Quaterniondc_, arg2: Internal.Vector3dc_): this;
        mapnXnYnZ(arg0: Internal.Matrix4x3d_): this;
        translation(arg0: Internal.Vector3fc_): this;
        set(arg0: Internal.Matrix4x3fc_): this;
        mapnYnZnX(arg0: Internal.Matrix4x3d_): this;
        add(arg0: Internal.Matrix4x3dc_): this;
        translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
        reflect(arg0: Internal.Quaterniondc_, arg1: Internal.Vector3dc_): this;
        assume(arg0: number): this;
        set(arg0: number, arg1: Internal.FloatBuffer_): this;
        mapZXnY(arg0: Internal.Matrix4x3d_): this;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3dc_, arg5: Internal.Matrix4x3d_): this;
        arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        rotateXYZ(arg0: number, arg1: number, arg2: number): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
        setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        mapXZnY(): this;
        mapYZnX(arg0: Internal.Matrix4x3d_): this;
        mapnZXnY(arg0: Internal.Matrix4x3d_): this;
        get(arg0: number[], arg1: number): number[];
        translationRotateInvert(arg0: Internal.Vector3dc_, arg1: Internal.Quaterniondc_): this;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
        setFromAddress(arg0: number): this;
        lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        scaling(arg0: Internal.Vector3dc_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        rotateLocal(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): this;
        mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        rotate(arg0: number, arg1: Internal.Vector3dc_): this;
        rotateLocal(arg0: Internal.Quaternionfc_): this;
        translationRotate(arg0: Internal.Vector3dc_, arg1: Internal.Quaterniondc_): this;
        translationRotateMul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: Internal.Matrix4x3dc_): this;
        normalizedPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        mapnXnZnY(): this;
        getTransposedFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        getEulerAnglesZYX(arg0: Internal.Vector3d_): Internal.Vector3d;
        getColumn(arg0: number, arg1: Internal.Vector3d_): Internal.Vector3d;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        setLookAt(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        mulComponentWise(arg0: Internal.Matrix4x3dc_): this;
        translateLocal(arg0: Internal.Vector3dc_): this;
        getFloats(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        mapnYXnZ(): this;
        translate(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3d_): this;
        setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapnXZnY(): this;
        translation(arg0: Internal.Vector3dc_): this;
        lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        cofactor3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        set(arg0: Internal.Matrix4x3dc_): this;
        setTranslation(arg0: number, arg1: number, arg2: number): this;
        mapXnZnY(): this;
        getRow(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
        getTransposedFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        rotateLocal(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        mapYXZ(arg0: Internal.Matrix4x3d_): this;
        rotateZYX(arg0: Internal.Vector3d_): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotationZ(arg0: number): this;
        mapYnXZ(): this;
        rotationAround(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: number): this;
        mapZnXnY(arg0: Internal.Matrix4x3d_): this;
        normalizedPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        readExternal(arg0: Internal.ObjectInput_): void;
        getScale(arg0: Internal.Vector3d_): Internal.Vector3d;
        sub(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        billboardCylindrical(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        lookAtLH(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_, arg3: Internal.Matrix4x3d_): this;
        translate(arg0: Internal.Vector3dc_, arg1: Internal.Matrix4x3d_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number): this;
        mapnYZX(): this;
        mapnXZY(): this;
        mapnYnXZ(arg0: Internal.Matrix4x3d_): this;
        mapnXnZY(): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapYnZX(arg0: Internal.Matrix4x3d_): this;
        mulOrtho(arg0: Internal.Matrix4x3dc_): this;
        getEulerAnglesXYZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        rotateZ(arg0: number): this;
        rotateLocal(arg0: Internal.Quaterniondc_): this;
        mapnZnXY(): this;
        mapnZYnX(arg0: Internal.Matrix4x3d_): this;
        pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Internal.Matrix4x3d_): this;
        set(arg0: Internal.FloatBuffer_): this;
        getFloats(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        normalizedPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        normalize3x3(): this;
        rotationXYZ(arg0: number, arg1: number, arg2: number): this;
        transformPosition(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        positiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        fma(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3d_): this;
        set(arg0: Internal.DoubleBuffer_): this;
        mapZYX(arg0: Internal.Matrix4x3d_): this;
        mapnZnXnY(arg0: Internal.Matrix4x3d_): this;
        lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        rotateXYZ(arg0: Internal.Vector3d_): this;
        setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        get4x4(arg0: number[]): number[];
        scale(arg0: number, arg1: number, arg2: number): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3d_): this;
        scaling(arg0: number): this;
        ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        determineProperties(): this;
        mapZnYnX(arg0: Internal.Matrix4x3d_): this;
        swap(arg0: Internal.Matrix4x3d_): this;
        rotateY(arg0: number): this;
        m20(): number;
        rotateLocalX(arg0: number): this;
        negateY(arg0: Internal.Matrix4x3d_): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        fma(arg0: Internal.Matrix4x3dc_, arg1: number, arg2: Internal.Matrix4x3d_): this;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        rotate(arg0: Internal.AxisAngle4d_): this;
        mapnZnYnX(arg0: Internal.Matrix4x3d_): this;
        translateLocal(arg0: number, arg1: number, arg2: number): this;
        getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        mapnXZY(arg0: Internal.Matrix4x3d_): this;
        positiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        m01(arg0: number): this;
        invert(): this;
        m31(): number;
        arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        mapnYnZX(): this;
        getTranslation(arg0: Internal.Vector3d_): Internal.Vector3d;
        scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        set(arg0: Internal.ByteBuffer_): this;
        translationRotateScaleMul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Internal.Matrix4x3dc_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3d_): this;
        reflect(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): this;
        rotate(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3d_): this;
        mul(arg0: Internal.Matrix4x3fc_): this;
        rotateX(arg0: number): this;
        get4x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        rotateX(arg0: number, arg1: Internal.Matrix4x3d_): this;
        get4x4(arg0: number[], arg1: number): number[];
        set(arg0: Internal.Quaterniondc_): this;
        set(arg0: number[], arg1: number): this;
        mapYnZX(): this;
        rotateLocalY(arg0: number): this;
        lerp(arg0: Internal.Matrix4x3dc_, arg1: number): this;
        negateZ(arg0: Internal.Matrix4x3d_): this;
        setLookAtLH(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        mapnXnYZ(): this;
        getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        set(arg0: Internal.AxisAngle4d_): this;
        m02(arg0: number): this;
        rotate(arg0: Internal.AxisAngle4f_): this;
        setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        m30(): number;
        positiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        mapXnYnZ(): this;
        set(arg0: number, arg1: Internal.DoubleBuffer_): this;
        rotation(arg0: number, arg1: Internal.Vector3fc_): this;
        mapnXnZY(arg0: Internal.Matrix4x3d_): this;
        scale(arg0: number): this;
        mapXnZY(): this;
        rotateLocalZ(arg0: number): this;
        rotation(arg0: Internal.AxisAngle4f_): this;
        scaling(arg0: number, arg1: number, arg2: number): this;
        mapnXYnZ(): this;
        rotate(arg0: Internal.Quaterniondc_): this;
        translate(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3d_): this;
        mapnZYX(): this;
        rotateY(arg0: number, arg1: Internal.Matrix4x3d_): this;
        mapXnZY(arg0: Internal.Matrix4x3d_): this;
        reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
        add(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        shadow(arg0: Internal.Vector4dc_, arg1: number, arg2: number, arg3: number, arg4: number): this;
        mapYZX(arg0: Internal.Matrix4x3d_): this;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        mapYXZ(): this;
        get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        mapnXnYnZ(): this;
        mapZnXY(arg0: Internal.Matrix4x3d_): this;
        setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        translationRotateMul(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_, arg4: Internal.Matrix4x3dc_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        setRow(arg0: number, arg1: Internal.Vector4dc_): this;
        set(arg0: number, arg1: Internal.ByteBuffer_): this;
        negateX(arg0: Internal.Matrix4x3d_): this;
        translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
        rotateZ(arg0: number, arg1: Internal.Matrix4x3d_): this;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        set(arg0: number[]): this;
        set(arg0: Internal.Quaternionfc_): this;
        rotate(arg0: number, arg1: Internal.Vector3fc_): this;
        get4x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        lookAt(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_, arg3: Internal.Matrix4x3d_): this;
        rotateAround(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: number): this;
        transformPosition(arg0: Internal.Vector3d_): Internal.Vector3d;
        translateLocal(arg0: Internal.Vector3fc_): this;
        mapZYnX(arg0: Internal.Matrix4x3d_): this;
        getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
        get4x4(arg0: number[], arg1: number): number[];
        mapXZY(arg0: Internal.Matrix4x3d_): this;
        arcball(arg0: number, arg1: Internal.Vector3dc_, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        rotation(arg0: number, arg1: Internal.Vector3dc_): this;
        negateY(): this;
        rotate(arg0: Internal.Quaterniondc_, arg1: Internal.Matrix4x3d_): this;
        normal(): this;
        scale(arg0: number, arg1: Internal.Matrix4x3d_): this;
        lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): this;
        rotateLocalZ(arg0: number, arg1: Internal.Matrix4x3d_): this;
        invertOrtho(): this;
        get4x4(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapnYnZX(arg0: Internal.Matrix4x3d_): this;
        rotate(arg0: Internal.Quaternionfc_): this;
        setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapZnYnX(): this;
        m32(arg0: number): this;
        m01(): number;
        mapnZnXY(arg0: Internal.Matrix4x3d_): this;
        rotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        mapZXY(): this;
        fma(arg0: Internal.Matrix4x3fc_, arg1: number): this;
        setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3d_): this;
        get(arg0: number[]): number[];
        mul(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): this;
        mapnZXY(): this;
        rotation(arg0: Internal.Quaterniondc_): this;
        mapXnYnZ(arg0: Internal.Matrix4x3d_): this;
        toString(arg0: Internal.NumberFormat_): string;
        m12(): number;
        m20(arg0: number): this;
        reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotationTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        mapnZnXnY(): this;
        billboardSpherical(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        mapXZY(): this;
        clone(): any;
        rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3d_): this;
        setRotationZYX(arg0: number, arg1: number, arg2: number): this;
        negateX(): this;
        writeExternal(arg0: Internal.ObjectOutput_): void;
        translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniondc_): this;
        rotation(arg0: Internal.AxisAngle4d_): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        setTranslation(arg0: Internal.Vector3dc_): this;
        getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        identity(): this;
        m10(arg0: number): this;
        mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3d_): this;
        m00(): number;
        equals(arg0: Internal.Matrix4x3dc_, arg1: number): boolean;
        translationRotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        get(arg0: number[]): number[];
        determinant(): number;
        properties(): number;
        invert(arg0: Internal.Matrix4x3d_): this;
        translate(arg0: Internal.Vector3dc_): this;
        translateLocal(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3d_): this;
        mapnZnYnX(): this;
        getTransposed(arg0: number[], arg1: number): number[];
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        m21(arg0: number): this;
        mapYZX(): this;
        mapnYnXZ(): this;
        getTransposed(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        transformDirection(arg0: Internal.Vector3d_): Internal.Vector3d;
        m11(): number;
        translationRotateScaleMul(arg0: Internal.Vector3dc_, arg1: Internal.Quaterniondc_, arg2: Internal.Vector3dc_, arg3: Internal.Matrix4x3dc_): this;
        get4x4(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        lookAt(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        mapnYXZ(): this;
        sub(arg0: Internal.Matrix4x3fc_): this;
        mapZnXnY(): this;
        mulOrtho(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        getTransposed(arg0: number[]): number[];
        shadow(arg0: Internal.Vector4dc_, arg1: Internal.Matrix4x3dc_): this;
        mapnYZX(arg0: Internal.Matrix4x3d_): this;
        transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Vector3d_, arg7: Internal.Vector3d_): this;
        rotateLocalX(arg0: number, arg1: Internal.Matrix4x3d_): this;
        set(arg0: Internal.Matrix4dc_): this;
        transpose3x3(arg0: Internal.Matrix4x3d_): this;
        mulTranslation(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
        m11(arg0: number): this;
        m22(): number;
        get(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        mulComponentWise(arg0: Internal.Matrix4x3dc_, arg1: Internal.Matrix4x3d_): this;
        rotation(arg0: Internal.Quaternionfc_): this;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Internal.Matrix4x3d_): this;
        m22(arg0: number): this;
        shadow(arg0: Internal.Vector4dc_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Matrix4x3d_): this;
        set(arg0: Internal.AxisAngle4f_): this;
        m10(): number;
        get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        mapYXnZ(): this;
        mapZYX(): this;
        scale(arg0: Internal.Vector3dc_): this;
        getTransposed(arg0: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        negateZ(): this;
        translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
        set(arg0: number[]): this;
        rotateLocalY(arg0: number, arg1: Internal.Matrix4x3d_): this;
        mapnZYnX(): this;
        setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): this;
        mul(arg0: Internal.Matrix4x3dc_): this;
        m12(arg0: number): this;
        m21(): number;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3d_): this;
        mapZnYX(arg0: Internal.Matrix4x3d_): this;
        frustumPlane(arg0: number, arg1: Internal.Vector4d_): Internal.Vector4d;
        add(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3d_): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3d_): this;
        getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        mapnXnYZ(arg0: Internal.Matrix4x3d_): this;
        set(arg0: Internal.Matrix3dc_): this;
        rotateTowards(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Matrix4x3d_): this;
        rotate(arg0: Internal.AxisAngle4f_, arg1: Internal.Matrix4x3d_): this;
        get(arg0: number, arg1: Internal.DoubleBuffer_): Internal.DoubleBuffer;
        setFloats(arg0: Internal.ByteBuffer_): this;
        billboardSpherical(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Vector3dc_): this;
        m00(arg0: number): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        m32(): number;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        mapnZXnY(): this;
        reflection(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_): this;
        sub(arg0: Internal.Matrix4x3dc_): this;
        get finite(): boolean
        set fromAddress(arg0: number)
        set translation(arg0: Internal.Vector3dc_)
        set floats(arg0: Internal.ByteBuffer_)
    }
    type Matrix4x3d_ = Matrix4x3d;
    class BeaconBlock extends Internal.BaseEntityBlock implements Internal.BeaconBeamBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
    }
    type BeaconBlock_ = BeaconBlock;
    class Matrix4x3f implements Internal.Matrix4x3fc, Internal.Cloneable, Internal.Externalizable {
        constructor()
        constructor(arg0: Internal.Matrix3fc_)
        constructor(arg0: Internal.FloatBuffer_)
        constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Vector3fc_)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number)
        constructor(arg0: Internal.Matrix4x3fc_)
        mapYXnZ(arg0: Internal.Matrix4x3f_): this;
        set(arg0: Internal.Matrix4fc_): this;
        rotationZ(arg0: number): this;
        mapnYnXZ(arg0: Internal.Matrix4x3f_): this;
        billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        mapYnXnZ(arg0: Internal.Matrix4x3f_): this;
        reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        rotateLocalY(arg0: number, arg1: Internal.Matrix4x3f_): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        mapnYnZnX(): this;
        pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Internal.Matrix4x3f_): this;
        get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        mapYZnX(): this;
        m31(arg0: number): this;
        getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
        lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Matrix4x3f_): this;
        mapnYnXnZ(arg0: Internal.Matrix4x3f_): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        m31(): number;
        rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        fma(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3f_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3f_): this;
        mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3f_): this;
        m20(arg0: number): this;
        mapYnZnX(): this;
        mapnZnYX(arg0: Internal.Matrix4x3f_): this;
        setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
        setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        rotateZ(arg0: number, arg1: Internal.Matrix4x3f_): this;
        cofactor3x3(arg0: Internal.Matrix4x3f_): this;
        rotationY(arg0: number): this;
        cofactor3x3(arg0: Matrix3f_): Matrix3f;
        arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        mapZnYX(): this;
        rotateLocalZ(arg0: number, arg1: Internal.Matrix4x3f_): this;
        m20(): number;
        obliqueZ(arg0: number, arg1: number, arg2: Internal.Matrix4x3f_): this;
        get(arg0: Matrix4f_): Matrix4f;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3fc_, arg5: Internal.Matrix4x3f_): this;
        translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
        rotation(arg0: number, arg1: Internal.Vector3fc_): this;
        transform(arg0: Vec4f_): Vec4f;
        setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        m32(arg0: number): this;
        set(arg0: Internal.Matrix3fc_): this;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        scaleXY(arg0: number, arg1: number, arg2: Internal.Matrix4x3f_): this;
        mapnYZnX(arg0: Internal.Matrix4x3f_): this;
        translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
        m32(): number;
        getScale(arg0: Vec3f_): Vec3f;
        set3x3(arg0: Internal.Matrix3fc_): this;
        rotateYXZ(arg0: Vec3f_): this;
        rotateY(arg0: number, arg1: Internal.Matrix4x3f_): this;
        normal(arg0: Internal.Matrix4x3f_): this;
        setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
        m21(arg0: number): this;
        mulOrtho(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        normal(arg0: Matrix3f_): Matrix3f;
        get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        add(arg0: Internal.Matrix4x3fc_): this;
        mapnXZnY(arg0: Internal.Matrix4x3f_): this;
        getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        mapnYXZ(arg0: Internal.Matrix4x3f_): this;
        mulTranslation(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        m21(): number;
        normalize3x3(arg0: Internal.Matrix4x3f_): this;
        mapnYnXnZ(): this;
        cofactor3x3(): this;
        isFinite(): boolean;
        reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): this;
        mapZYnX(): this;
        shadow(arg0: Internal.Vector4fc_, arg1: Internal.Matrix4x3fc_, arg2: Internal.Matrix4x3f_): this;
        transpose3x3(): this;
        m10(arg0: number): this;
        translationRotateMul(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_, arg4: Internal.Matrix4x3fc_): this;
        lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        m10(): number;
        mulComponentWise(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        invertOrtho(arg0: Internal.Matrix4x3f_): this;
        scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        sub(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        rotateX(arg0: number, arg1: Internal.Matrix4x3f_): this;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        withLookAtUp(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): this;
        setTranslation(arg0: number, arg1: number, arg2: number): this;
        m22(arg0: number): this;
        translate(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): this;
        mapYnZnX(arg0: Internal.Matrix4x3f_): this;
        mapnZnYX(): this;
        get(arg0: Internal.Matrix4x3f_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        mapYnXZ(arg0: Internal.Matrix4x3f_): this;
        ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
        scale(arg0: number, arg1: Internal.Matrix4x3f_): this;
        transpose3x3(arg0: Matrix3f_): Matrix3f;
        setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        m22(): number;
        getToAddress(arg0: number): Internal.Matrix4x3fc;
        mapXnZnY(arg0: Internal.Matrix4x3f_): this;
        m11(arg0: number): this;
        mapnZXY(arg0: Internal.Matrix4x3f_): this;
        zero(): this;
        rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): this;
        mapZXnY(): this;
        mapYnXnZ(): this;
        setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        m11(): number;
        reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        mulComponentWise(arg0: Internal.Matrix4x3fc_): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        mapnXnZnY(arg0: Internal.Matrix4x3f_): this;
        mapZnXY(): this;
        translate(arg0: Internal.Vector3fc_): this;
        mapnYZnX(): this;
        setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        m00(arg0: number): this;
        ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        translation(arg0: Internal.Vector3fc_): this;
        translationRotateScaleMul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Internal.Matrix4x3f_): this;
        shadow(arg0: Internal.Vector4fc_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.Matrix4x3f_): this;
        m00(): number;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapYnZX(arg0: Internal.Matrix4x3f_): this;
        setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        lerp(arg0: Internal.Matrix4x3fc_, arg1: number): this;
        set(arg0: number, arg1: Internal.FloatBuffer_): this;
        rotationZYX(arg0: number, arg1: number, arg2: number): this;
        assume(arg0: number): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3f_): this;
        transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
        set(arg0: Internal.Matrix4x3fc_): this;
        setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapnZYnX(arg0: Internal.Matrix4x3f_): this;
        m12(): number;
        translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
        get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        normalizedPositiveX(arg0: Vec3f_): Vec3f;
        transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        mapXZnY(): this;
        mapZYnX(arg0: Internal.Matrix4x3f_): this;
        getColumn(arg0: number, arg1: Vec3f_): Vec3f;
        get(arg0: number[], arg1: number): number[];
        translateLocal(arg0: number, arg1: number, arg2: number): this;
        mapnXYnZ(arg0: Internal.Matrix4x3f_): this;
        mapZYX(arg0: Internal.Matrix4x3f_): this;
        mapnXnYnZ(arg0: Internal.Matrix4x3f_): this;
        m01(): number;
        setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        scaleLocal(arg0: number, arg1: number, arg2: number): this;
        setFromAddress(arg0: number): this;
        mapnYnZnX(arg0: Internal.Matrix4x3f_): this;
        translation(arg0: number, arg1: number, arg2: number): this;
        getRow(arg0: number, arg1: Vec4f_): Vec4f;
        mapZXnY(arg0: Internal.Matrix4x3f_): this;
        rotateLocal(arg0: Internal.Quaternionfc_): this;
        scaling(arg0: number, arg1: number, arg2: number): this;
        normalizedPositiveY(arg0: Vec3f_): Vec3f;
        billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        mapnXnZnY(): this;
        rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Matrix4x3f_): this;
        mapYZnX(arg0: Internal.Matrix4x3f_): this;
        mapnZXnY(arg0: Internal.Matrix4x3f_): this;
        mapnYXnZ(): this;
        translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
        mapnXZnY(): this;
        lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3f_): this;
        mapXnZnY(): this;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Internal.Matrix4x3f_): this;
        rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        m02(): number;
        mapYnXZ(): this;
        normalizedPositiveZ(arg0: Vec3f_): Vec3f;
        mapZXY(arg0: Internal.Matrix4x3f_): this;
        readExternal(arg0: Internal.ObjectInput_): void;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
        getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
        positiveX(arg0: Vec3f_): Vec3f;
        setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        mapnZnXnY(arg0: Internal.Matrix4x3f_): this;
        mulOrtho(arg0: Internal.Matrix4x3fc_): this;
        mapnYZX(): this;
        rotateXYZ(arg0: Vec3f_): this;
        mapnXZY(): this;
        mapnXnZY(): this;
        lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotate(arg0: number, arg1: Internal.Vector3fc_): this;
        rotateLocalX(arg0: number, arg1: Internal.Matrix4x3f_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        translateLocal(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        mapZnYnX(arg0: Internal.Matrix4x3f_): this;
        m30(arg0: number): this;
        mapYXZ(arg0: Internal.Matrix4x3f_): this;
        rotateZYX(arg0: Vec3f_): this;
        mapnZnXY(): this;
        rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
        mapZnXnY(arg0: Internal.Matrix4x3f_): this;
        setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        normalize3x3(): this;
        set(arg0: Internal.FloatBuffer_): this;
        mapnZnYnX(arg0: Internal.Matrix4x3f_): this;
        positiveY(arg0: Vec3f_): Vec3f;
        shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
        get4x4(arg0: number[]): number[];
        mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
        getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
        rotate(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): this;
        determineProperties(): this;
        transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        negateZ(arg0: Internal.Matrix4x3f_): this;
        setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
        rotateLocalZ(arg0: number): this;
        scale(arg0: number): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        mapXZY(arg0: Internal.Matrix4x3f_): this;
        scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        mapnYnZX(): this;
        translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
        invert(): this;
        positiveZ(arg0: Vec3f_): Vec3f;
        rotateXYZ(arg0: number, arg1: number, arg2: number): this;
        mapnXnZY(arg0: Internal.Matrix4x3f_): this;
        setRow(arg0: number, arg1: Internal.Vector4fc_): this;
        scale(arg0: Internal.Vector3fc_): this;
        lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Internal.Matrix4x3f_): this;
        mapnYZX(arg0: Internal.Matrix4x3f_): this;
        setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        set(arg0: Internal.ByteBuffer_): this;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        mul(arg0: Internal.Matrix4x3fc_): this;
        mapXnZY(arg0: Internal.Matrix4x3f_): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        get4x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        get4x4(arg0: number[], arg1: number): number[];
        set(arg0: number[], arg1: number): this;
        rotateLocal(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): this;
        set(arg0: Internal.Quaterniondc_): this;
        mapYnZX(): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
        mapnXnYZ(): this;
        rotateLocalY(arg0: number): this;
        withLookAtUp(arg0: Internal.Vector3fc_): this;
        getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): this;
        rotate(arg0: Internal.AxisAngle4f_): this;
        mapnXZY(arg0: Internal.Matrix4x3f_): this;
        mapXnYnZ(): this;
        rotationXYZ(arg0: number, arg1: number, arg2: number): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Internal.Matrix4x3f_): this;
        getTransposed(arg0: number[]): number[];
        set(arg0: Internal.AxisAngle4d_): this;
        mapXnZY(): this;
        equals(arg0: Internal.Matrix4x3fc_, arg1: number): boolean;
        rotation(arg0: Internal.AxisAngle4f_): this;
        mapnZYX(): this;
        withLookAtUp(arg0: number, arg1: number, arg2: number): this;
        set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): this;
        mapnXYnZ(): this;
        reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        negateX(arg0: Internal.Matrix4x3f_): this;
        get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        rotateY(arg0: number): this;
        invert(arg0: Internal.Matrix4x3f_): this;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Internal.Matrix4x3f_): this;
        rotateZYX(arg0: number, arg1: number, arg2: number): this;
        set(arg0: Internal.Quaternionfc_): this;
        mapYXZ(): this;
        set(arg0: number[]): this;
        rotateLocalX(arg0: number): this;
        scaleXY(arg0: number, arg1: number): this;
        transformPosition(arg0: Vec3f_): Vec3f;
        reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
        transformDirection(arg0: Vec3f_): Vec3f;
        lerp(arg0: Internal.Matrix4x3fc_, arg1: number, arg2: Internal.Matrix4x3f_): this;
        get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        mapnXnYnZ(): this;
        get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Internal.Vector3fc_): this;
        pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
        scale(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        rotateZ(arg0: number): this;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        swap(arg0: Internal.Matrix4x3f_): this;
        scaling(arg0: Internal.Vector3fc_): this;
        scaling(arg0: number): this;
        lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
        set(arg0: number, arg1: Internal.ByteBuffer_): this;
        negateY(arg0: Internal.Matrix4x3f_): this;
        translateLocal(arg0: Internal.Vector3fc_): this;
        get4x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        translationRotateScaleMul(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Internal.Matrix4x3f_): this;
        mapYZX(arg0: Internal.Matrix4x3f_): this;
        mapXnYnZ(arg0: Internal.Matrix4x3f_): this;
        getTransposed(arg0: number[], arg1: number): number[];
        setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
        getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
        scale(arg0: number, arg1: number, arg2: number): this;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
        obliqueZ(arg0: number, arg1: number): this;
        billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        rotate(arg0: Internal.Quaternionfc_): this;
        mapZnYnX(): this;
        normal(): this;
        invertOrtho(): this;
        get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        negateY(): this;
        get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
        rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        rotateYXZ(arg0: number, arg1: number, arg2: number): this;
        reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
        orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Matrix4x3f_): this;
        rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        m12(arg0: number): this;
        frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
        translationRotateMul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: Internal.Matrix4x3fc_): this;
        mapZXY(): this;
        mapXZY(): this;
        translateLocal(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): this;
        get(arg0: number[]): number[];
        mapnZXY(): this;
        get4x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        toString(arg0: Internal.NumberFormat_): string;
        arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
        rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        m01(arg0: number): this;
        mapnZnXnY(): this;
        rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        clone(): any;
        negateX(): this;
        writeExternal(arg0: Internal.ObjectOutput_): void;
        invert(arg0: Matrix4f_): Matrix4f;
        getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        rotationYXZ(arg0: number, arg1: number, arg2: number): this;
        setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
        mapnYnZX(arg0: Internal.Matrix4x3f_): this;
        setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
        identity(): this;
        getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        mapnZnXY(arg0: Internal.Matrix4x3f_): this;
        rotateX(arg0: number): this;
        scale(arg0: Internal.Vector3fc_, arg1: Internal.Matrix4x3f_): this;
        properties(): number;
        mul(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
        mapnZnYnX(): this;
        ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
        rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        mapYZX(): this;
        m02(arg0: number): this;
        mapnYnXZ(): this;
        mapZnXnY(): this;
        mapnYXZ(): this;
        mapnZYX(arg0: Internal.Matrix4x3f_): this;
        mapZnXY(arg0: Internal.Matrix4x3f_): this;
        sub(arg0: Internal.Matrix4x3fc_): this;
        translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
        fma(arg0: Internal.Matrix4x3fc_, arg1: number): this;
        normalize3x3(arg0: Matrix3f_): Matrix3f;
        rotationX(arg0: number): this;
        translate(arg0: number, arg1: number, arg2: number): this;
        setRotationZYX(arg0: number, arg1: number, arg2: number): this;
        get4x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        mapZnYX(arg0: Internal.Matrix4x3f_): this;
        add(arg0: Internal.Matrix4x3fc_, arg1: Internal.Matrix4x3f_): this;
        shadow(arg0: Internal.Vector4fc_, arg1: number, arg2: number, arg3: number, arg4: number): this;
        mapnXnYZ(arg0: Internal.Matrix4x3f_): this;
        rotate(arg0: Internal.AxisAngle4f_, arg1: Internal.Matrix4x3f_): this;
        rotation(arg0: Internal.Quaternionfc_): this;
        mapYXnZ(): this;
        set(arg0: Internal.AxisAngle4f_): this;
        get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        translate(arg0: number, arg1: number, arg2: number, arg3: Internal.Matrix4x3f_): this;
        setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
        determinant(): number;
        ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4x3f_): this;
        mapZYX(): this;
        setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
        setTranslation(arg0: Internal.Vector3fc_): this;
        set3x3(arg0: Internal.Matrix4x3fc_): this;
        rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Matrix4x3f_): this;
        mapnYXnZ(arg0: Internal.Matrix4x3f_): this;
        mapXZnY(arg0: Internal.Matrix4x3f_): this;
        ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
        negateZ(): this;
        reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        shadow(arg0: Internal.Vector4fc_, arg1: Internal.Matrix4x3fc_): this;
        transpose3x3(arg0: Internal.Matrix4x3f_): this;
        rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Internal.Matrix4x3f_): this;
        mapnZYnX(): this;
        getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        origin(arg0: Vec3f_): Vec3f;
        getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
        mapnZXnY(): this;
        m30(): number;
        transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
        rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
        getTranslation(arg0: Vec3f_): Vec3f;
        get finite(): boolean
        set fromAddress(arg0: number)
        set translation(arg0: Internal.Vector3fc_)
    }
    type Matrix4x3f_ = Matrix4x3f;
    class GenerateClientAssetsEventJS extends Internal.EventJS {
        constructor(gen: Internal.AssetJsonGenerator_)
        addMultipartBlockState(id: ResourceLocation_, consumer: Internal.Consumer_<Internal.MultipartBlockStateGenerator>): void;
        add(location: ResourceLocation_, json: Internal.JsonElement_): void;
        defaultItemModel(id: ResourceLocation_): void;
        addLang(key: string, value: string): void;
        addBlockState(id: ResourceLocation_, consumer: Internal.Consumer_<Internal.VariantBlockStateGenerator>): void;
        stencil(target: ResourceLocation_, stencil: string, colors: Internal.JsonObject_): void;
        defaultHandheldItemModel(id: ResourceLocation_): void;
        addModel(type: string, id: ResourceLocation_, consumer: Internal.Consumer_<Internal.ModelGenerator>): void;
        readonly generator: Internal.AssetJsonGenerator;
    }
    type GenerateClientAssetsEventJS_ = GenerateClientAssetsEventJS;
    class Inventory implements net.minecraft.world.Container, Internal.Nameable {
        constructor($$0: Internal.Player_)
        stopOpen($$0: Internal.Player_): void;
        getSlotWithRemainingSpace($$0: Internal.ItemStack_): number;
        removeFromSelected($$0: boolean): Internal.ItemStack;
        add($$0: number, $$1: Internal.ItemStack_): boolean;
        static tryClear($$0: any): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        static getSelectionSize(): number;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        add($$0: Internal.ItemStack_): boolean;
        dropAll(): void;
        removeItem($$0: number, $$1: number): Internal.ItemStack;
        getSlots(): number;
        placeItemBackInInventory($$0: Internal.ItemStack_): void;
        contains($$0: Internal.TagKey_<Internal.Item>): boolean;
        setChanged(): void;
        setPickedItem($$0: Internal.ItemStack_): void;
        swapPaint($$0: number): void;
        getContainerSize(): number;
        setItem($$0: number, $$1: Internal.ItemStack_): void;
        replaceWith($$0: Internal.Inventory_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getSuitableHotbarSlot(): number;
        getName(): net.minecraft.network.chat.Component;
        kjs$self(): net.minecraft.world.Container;
        findSlotMatchingItem($$0: Internal.ItemStack_): number;
        load($$0: Internal.ListTag_): void;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getArmor($$0: number): Internal.ItemStack;
        removeItemNoUpdate($$0: number): Internal.ItemStack;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getDestroySpeed($$0: Internal.BlockState_): number;
        hasCustomName(): boolean;
        tick(): void;
        removeItem($$0: Internal.ItemStack_): void;
        handler$fej000$moonlight$restoreNotDropped(ci: Internal.CallbackInfo_, var1: Internal.Iterator_<any>, list: Internal.List_<any>, i: number): void;
        getItem($$0: number): Internal.ItemStack;
        getSelected(): Internal.ItemStack;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        getCustomName(): net.minecraft.network.chat.Component;
        getDisplayName(): net.minecraft.network.chat.Component;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        clearOrCountMatchingItems($$0: Internal.Predicate_<Internal.ItemStack>, $$1: number, $$2: net.minecraft.world.Container_): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        hurtArmor($$0: DamageSource_, $$1: number, $$2: number[]): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        handler$fej000$moonlight$fireDropEvent(ci: Internal.CallbackInfo_, var1: Internal.Iterator_<any>, list: Internal.List_<any>, i: number): void;
        countNonEmpty(): number;
        hasRemainingSpaceForItem($$0: Internal.ItemStack_, $$1: Internal.ItemStack_): boolean;
        asContainer(): net.minecraft.world.Container;
        save($$0: Internal.ListTag_): Internal.ListTag;
        getAllItems(): Internal.List<Internal.ItemStack>;
        fillStackedContents($$0: Internal.StackedContents_): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        addResource($$0: number, $$1: Internal.ItemStack_): number;
        stillValid($$0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getTimesChanged(): number;
        static isHotbarSlot($$0: number): boolean;
        placeItemBackInInventory($$0: Internal.ItemStack_, $$1: boolean): void;
        contains($$0: Internal.ItemStack_): boolean;
        pickSlot($$0: number): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        findSlotMatchingUnusedItem($$0: Internal.ItemStack_): number;
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        getFreeSlot(): number;
        get selectionSize(): number
        get slots(): number
        set pickedItem($$0: Internal.ItemStack_)
        get containerSize(): number
        get suitableHotbarSlot(): number
        get name(): net.minecraft.network.chat.Component
        get width(): number
        get maxStackSize(): number
        get selected(): Internal.ItemStack
        get customName(): net.minecraft.network.chat.Component
        get displayName(): net.minecraft.network.chat.Component
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get timesChanged(): number
        get mutable(): boolean
        get freeSlot(): number
        readonly armor: Internal.NonNullList<Internal.ItemStack>;
        readonly player: Internal.Player;
        static readonly INVENTORY_SIZE: 36;
        static readonly SLOT_OFFHAND: 40;
        readonly offhand: Internal.NonNullList<Internal.ItemStack>;
        static readonly NOT_FOUND_INDEX: -1;
        static readonly ALL_ARMOR_SLOTS: number[];
        static readonly HELMET_SLOT_ONLY: number[];
        selected: number;
        static readonly POP_TIME_DURATION: 5;
        readonly items: Internal.NonNullList<Internal.ItemStack>;
    }
    type Inventory_ = Inventory;
}
declare namespace dev.ftb.mods.ftbteams.api {
    interface Team {
        isPartyTeam(): boolean;
        abstract getOnlineMembers(): Internal.Collection<Internal.ServerPlayer>;
        abstract getExtraData(): Internal.CompoundTag;
        abstract getPlayersByRank(arg0: Internal.TeamRank_): Internal.Map<Internal.UUID, Internal.TeamRank>;
        abstract setProperty<T>(arg0: Internal.TeamProperty_<T>, arg1: T): void;
        abstract sendMessage(arg0: Internal.UUID_, arg1: string): void;
        abstract getTeamId(): Internal.UUID;
        abstract getMessageHistory(): Internal.List<Internal.TeamMessage>;
        isPlayerTeam(): boolean;
        abstract isValid(): boolean;
        abstract markDirty(): void;
        abstract getName(): net.minecraft.network.chat.Component;
        abstract getShortName(): string;
        abstract getMembers(): Internal.Set<Internal.UUID>;
        isClientTeam(): boolean;
        abstract getOwner(): Internal.UUID;
        abstract getColoredName(): net.minecraft.network.chat.Component;
        abstract getTeamInfo(): Internal.List<net.minecraft.network.chat.Component>;
        abstract createParty(arg0: string, arg1: Internal.Color4I_): this;
        abstract getId(): Internal.UUID;
        abstract getRankForPlayer(arg0: Internal.UUID_): Internal.TeamRank;
        abstract getTypeTranslationKey(): string;
        isServerTeam(): boolean;
        abstract getProperty<T>(arg0: Internal.TeamProperty_<T>): T;
        abstract getProperties(): Internal.TeamPropertyCollection;
        get partyTeam(): boolean
        get onlineMembers(): Internal.Collection<Internal.ServerPlayer>
        get extraData(): Internal.CompoundTag
        get teamId(): Internal.UUID
        get messageHistory(): Internal.List<Internal.TeamMessage>
        get playerTeam(): boolean
        get valid(): boolean
        get name(): net.minecraft.network.chat.Component
        get shortName(): string
        get members(): Internal.Set<Internal.UUID>
        get clientTeam(): boolean
        get owner(): Internal.UUID
        get coloredName(): net.minecraft.network.chat.Component
        get teamInfo(): Internal.List<net.minecraft.network.chat.Component>
        get id(): Internal.UUID
        get typeTranslationKey(): string
        get serverTeam(): boolean
        get properties(): Internal.TeamPropertyCollection
    }
    type Team_ = Team;
}
